package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.wolf.utils.SecurityUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;

/**
 * 签名工具类
 * @author lizhi
 * @date 2021/12/3 3:30 下午
 */
public class SignUtil {

    private SignUtil() {

    }

    /**
     * 判断签名是否正确，必须包含签名字段，否则返回false。
     *
     * @param data Map类型数据
     * @param key API密钥
     * @param signName 签名字段名
     * @return 签名是否正确
     */
    public static boolean isSignatureValidByMd5(Map<String, String> data, String key, String signName) {
        if (data == null || data.isEmpty())  {
            return false;
        }
        if (!data.containsKey(signName) ) {
            return false;
        }
        String sign = data.get(signName);
        return generateSignatureByMd5(data, key, signName).equals(sign);
    }

    /**
     * 生成签名
     *
     * @param data 待签名数据
     * @param key API密钥
     * @param signName 签名字段名，若待签名数据中包含该字段，则跳过
     * @return 签名
     */
    public static String generateSignatureByMd5(final Map<String, String> data, String key, String signName) {
        if (data == null || data.isEmpty())  {
            return "";
        }
        Set<String> keySet = data.keySet();
        String[] keyArray = keySet.toArray(new String[0]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (String k : keyArray) {
            if (k.equals(signName)) {
                continue;
            }
            if (data.get(k).trim().length() > 0) {
                // 参数值为空，则不参与签名
                sb.append(k).append("=").append(data.get(k).trim()).append("&");
            }
        }
        sb.append("key=").append(key);
        return SecurityUtils.encode2StringByMd5(sb.toString()).toUpperCase();
    }
}
