package cn.com.duiba.kjy.base.customweb.web.codec;

import cn.com.duiba.kjy.base.customweb.web.codec.jackson.JacksonIdDeserialization;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by dugq on 2019-05-13.
 * 自动解密参数
 * 具体的参数配置，看属性描述
 */
@Target({ElementType.PARAMETER,ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@JacksonAnnotationsInside
@JsonDeserialize(using = JacksonIdDeserialization.class)
public @interface IdDecode {

    /**
     * 解密数组和集合类型的时候必填
     * 因为java范型获取不到具体类型，无法解析。需要显示指定
     * 声明： 不支持map。理由： map本身不适合做param，其次，map的加入将会让数据结构复杂度大增，不利于解析
     * @return
     */
    Class type() default Object.class;

}
