package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.List;

/**
 * @author dugq
 * @date 2021/3/25 11:08 上午
 */
public class CustomFilterChain {

    private final List<CustomFilter> filterList;
    private int pos;
    private int size;
    private final DispatcherHandler dispatcherHandler;
    private StopWatch stopWatch;

    public CustomFilterChain(List<CustomFilter> filterList, DispatcherHandler dispatcherHandler) {
        this.filterList = filterList;
        this.dispatcherHandler = dispatcherHandler;
        this.pos = 0;
        this.size = filterList.size();
        stopWatch = StopWatchUtil.getAndStart();
    }

    public void filter(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(filterList)){
            dispatcherHandler.service(httpRequest,response);
        }
        if (pos < size){
            final CustomFilter customFilter = filterList.get(pos++);
            customFilter.doFilter(this,httpRequest, response);
        }else{
            StopWatchUtil.stop(StopWatchUtil.Key.FILTER,httpRequest,stopWatch);
            dispatcherHandler.service(httpRequest,response);
        }
    }

}
