package cn.com.duiba.kjy.base.customweb.web.handler.mapping;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import lombok.Getter;
import org.springframework.util.StopWatch;

import java.util.List;

/**
 * @author dugq
 * @date 2021/3/29 4:50 下午
 */
@Getter
public class HandlerExecutionChain {

    private final List<KjjInterceptor> interceptors;
    private final RequestMappingsRegister requestMappingsRegister;
    private final Object handler;

    public HandlerExecutionChain(List<KjjInterceptor> kjjInterceptors, RequestMappingsRegister requestMappingsRegister, Object handler) {
        this.requestMappingsRegister = requestMappingsRegister;
        this.interceptors = kjjInterceptors;
        this.handler = handler;
    }


    public boolean applyPreHandle(KjjHttpRequest fullHttpRequest, KjjHttpResponse response, Object controllerMappingHandler){
        final StopWatch interceptor = StopWatchUtil.getAndStart();
        for (KjjInterceptor kjjInterceptor : interceptors) {
            if (!kjjInterceptor.applyPreHandle(fullHttpRequest,response, controllerMappingHandler)){
                return true;
            }
        }
        StopWatchUtil.stop(StopWatchUtil.Key.INTERCEPTOR_BEFORE,fullHttpRequest,interceptor);
        return false;
    }

    public void applyPostHandle(KjjHttpRequest request, KjjHttpResponse response, Object handler, Object result){
        final StopWatch interceptor = StopWatchUtil.getAndStart();
        for (KjjInterceptor kjjInterceptor : interceptors) {
            kjjInterceptor.applyPostHandle(request,response, handler,result);
        }
        StopWatchUtil.stop(StopWatchUtil.Key.INTERCEPTOR_AFTER,request,interceptor);
    }

    public void afterCompletion(KjjHttpRequest request, KjjHttpResponse response,Exception e){
        for (KjjInterceptor kjjInterceptor : interceptors) {
            kjjInterceptor.afterCompletion(request,response, handler,e);
        }
    }

    public RequestHandlerMappingAdaptor getAdaptor(){
        return requestMappingsRegister.getAdaptor();
    }

}
