package cn.com.duiba.kjy.base.exception.errorcode;

import cn.com.duiba.kjy.base.api.request.ErrorCodeInterface;
import lombok.Getter;

/**
 * @author dugq
 * @date 2021/11/8 3:10 下午
 */
@Getter
public enum  BaseErrorCode implements ErrorCodeInterface {
    ID_ERROR("100000","非法ID"),
    PARAM_ERROR("990000","参数错误"),
    SYSTEM_BUSY("990001","系统繁忙，请稍后重试"),
    SYSTEM_ERROR("999999","系统错误"),
    ;
    private final String shortCode;
    private final String desc;

    BaseErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "BS";
    }
}
