/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.enums;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.api.utils.UrlUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProviderChannelEnum {
    WECHAT_OA(1, "/oax", "\u4e2a\u5fae\u516c\u4f17\u53f7"),
    WX_WORK(2, "/qywx", "\u4f01\u5fae\u5e94\u7528"),
    THIRD_PARTY_APP(3, "/app", "\u7b2c\u4e09\u65b9APP");

    private static final Logger log;
    private final Integer code;
    private final String urlPrefix;
    private final String desc;
    private static final Map<Integer, ProviderChannelEnum> ENUM_MAP;

    private ProviderChannelEnum(Integer code, String urlPrefix, String desc) {
        this.code = code;
        this.urlPrefix = urlPrefix;
        this.desc = desc;
    }

    public static ProviderChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getUrl(String channelId, String subUrl) {
        if (StringUtils.isBlank((String)channelId)) {
            return subUrl;
        }
        return this.urlPrefix + "/" + channelId + subUrl;
    }

    public String getUrl(Long channelId, String subUrl) {
        if (Objects.isNull(channelId)) {
            return subUrl;
        }
        return this.urlPrefix + "/" + IdMakeUtil.encodingId(channelId) + subUrl;
    }

    public String autoJoinChannel(Long channelId, String subUrl, String serverDomain) {
        return this.doJoinUrl(serverDomain, subUrl, IdMakeUtil.encodingId(channelId));
    }

    public String autoJoinChannel(String channelMarking, String subUrl, String serverDomain) {
        return this.doJoinUrl(serverDomain, subUrl, channelMarking);
    }

    @NotNull
    private String doJoinUrl(String serverDomain, String url, String channelMarking) {
        if (StringUtils.isBlank((String)url)) {
            url = "/";
        }
        URI uri = URI.create(url);
        StringBuilder formatUri = new StringBuilder();
        this.appendServer(serverDomain, uri, formatUri);
        boolean appendChannel = this.appendPath(channelMarking, uri, formatUri);
        return this.appendQuery(uri, formatUri, appendChannel, channelMarking);
    }

    private String appendQuery(URI uri, StringBuilder formatUri, boolean appendChannel, String channelMarking) {
        String redirectUrl = formatUri.toString();
        if (appendChannel) {
            if (StringUtils.isBlank((String)uri.getRawQuery())) {
                return redirectUrl;
            }
            return UrlUtils.appendQueryParam(redirectUrl, uri.getRawQuery());
        }
        if (StringUtils.isBlank((String)uri.getRawQuery())) {
            return formatUri.append("?").append("channelMarking").append("=").append(channelMarking).toString();
        }
        Map<String, String> queryMap = UrlUtils.parseQueryString(uri.getRawQuery());
        queryMap.put("channelMarking", channelMarking);
        return UrlUtils2.appendParams((String)redirectUrl, queryMap);
    }

    private boolean appendPath(String channelMarking, URI uri, StringBuilder formatUri) {
        String rawPath = this.getPath(uri.getRawPath());
        if (StringUtils.isBlank((String)channelMarking)) {
            formatUri.append(rawPath);
        } else if (StringUtils.startsWith((String)rawPath, (String)"/kjj/jump")) {
            String prefix = ProviderChannelEnum.getByCode(this.getCode()).getUrl(channelMarking, "");
            String path = UrlUtils.appendQueryParam(rawPath, "urlPrefix=" + prefix);
            formatUri.append(path);
        } else if (StringUtils.startsWith((String)rawPath, (String)"/pages") || StringUtils.startsWith((String)rawPath, (String)"/basic")) {
            String path = ProviderChannelEnum.getByCode(this.getCode()).getUrl(channelMarking, rawPath);
            formatUri.append(path);
        } else {
            formatUri.append(rawPath);
            return false;
        }
        return true;
    }

    private void appendServer(String serverDomain, URI uri, StringBuilder formatUri) {
        if (StringUtils.isBlank((String)uri.getHost())) {
            if (StringUtils.isNotBlank((String)serverDomain)) {
                formatUri.append(serverDomain);
            }
        } else {
            if (StringUtils.isNotBlank((String)uri.getScheme())) {
                formatUri.append(uri.getScheme());
                formatUri.append("://");
            } else {
                formatUri.append("https://");
            }
            formatUri.append(uri.getHost());
        }
    }

    private String getPath(String path) {
        if (StringUtils.equals((String)"/", (String)path)) {
            return "/kjj/jump?sense=1";
        }
        return path;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(ProviderChannelEnum.class);
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ProviderChannelEnum.values()).collect(Collectors.toMap(ProviderChannelEnum::getCode, Function.identity(), (v1, v2) -> {
            log.error("ProviderChannelEnum, type distinct, type={}", (Object)v2.getCode());
            return v2;
        })));
    }
}

