/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.util;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactResponseUtils {
    public static <T extends Serializable> Mono<Void> writeMessage(ServerWebExchange serverWebExchange, T message) {
        if (Objects.isNull(message)) {
            return Mono.empty();
        }
        ServerHttpResponse response = serverWebExchange.getResponse();
        if (message instanceof String) {
            return ReactResponseUtils.writeMsg((String)((Object)message), response);
        }
        return ReactResponseUtils.writeMsg(JSONObject.toJSONString(message), response);
    }

    public static <T extends Serializable> Mono<Void> writeMsg(String message, ServerHttpResponse response) {
        DataBuffer wrap = response.bufferFactory().wrap(message.getBytes());
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return response.writeWith((Publisher)Mono.just((Object)wrap));
    }
}

