package cn.com.duibaboot.kjj.oss.template.support;

import com.aliyun.oss.model.OSSObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;

import java.io.IOException;

/**
 * @author dugq
 * @date 2021/8/23 1:47 下午
 */
@Slf4j
public class DownloadHelper {


    /**
     * 下载文件流为字符串。
     * @param ossObject oss流对象
     * @return 字符串
     */
    public static String downloadString(OSSObject ossObject){
        try {
            final String contentEncoding = ossObject.getObjectMetadata().getContentEncoding();
            return IOUtils.toString(ossObject.getObjectContent(),contentEncoding);
        } catch (IOException e) {
            log.error("下载失败");
            return null;
        }
    }

}
