/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.queue;

import cn.com.duiba.kjy.base.api.queue.AbstractHttpQueueService;
import cn.com.duiba.kjy.base.api.queue.HttpRequestBaseBean;
import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpQueueDealWithLiveService<T extends HttpRequestBaseBean>
extends AbstractHttpQueueService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpQueueDealWithLiveService.class);

    public AbstractHttpQueueDealWithLiveService(int capacity, int batchSize, int maxWaitSize, int maxWaitTimeMillis) {
        super(capacity, batchSize, maxWaitSize, maxWaitTimeMillis);
    }

    @Override
    protected void batchConsumeMsg(List<T> list) {
        Map<Long, List<HttpRequestBaseBean>> liveIdBeanListMap = list.stream().filter(bean -> {
            if (NumberUtil.isNullOrLteZero(bean.getLiveId())) {
                log.error("batchConsumeHttpMsg, liveId is null or zero, bean={}", bean);
                this.overRequestFail(bean, BaseErrorCode.PARAM_ERROR);
                return false;
            }
            return true;
        }).collect(Collectors.groupingBy(HttpRequestBaseBean::getLiveId));
        liveIdBeanListMap.forEach((key, beanList) -> {
            try {
                this.batchConsumeLiveMsg((Long)key, (List<T>)beanList);
            }
            catch (Exception e) {
                this.batchOverRequestFail(beanList, BaseErrorCode.SYSTEM_BUSY);
                log.error("batchConsumeHttpMsg, class={}, e:", (Object)this.getClass().getName(), (Object)e);
            }
        });
    }

    protected abstract void batchConsumeLiveMsg(Long var1, List<T> var2);
}

