/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.RequestTypeEnum;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossDomainResponseFilter
implements CustomFilter {
    private static final Logger log = LoggerFactory.getLogger(CrossDomainResponseFilter.class);
    private final List<String> domains;
    private final String allowHeads;

    public CrossDomainResponseFilter(String domains, String headers) {
        this.domains = StringUtils.isBlank((CharSequence)domains) ? Collections.emptyList() : Arrays.asList(domains.split(","));
        if (StringUtils.isBlank((CharSequence)headers)) {
            headers = "Content-Type, x-requested-with, Origin, X-Requested-With, Content-Type, Accept, Cookie";
        }
        this.allowHeads = headers;
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)httpRequest.getMethod(), (CharSequence)RequestTypeEnum.OPTIONS.getType())) {
                this.dealOptionRequest(httpRequest, response);
                return;
            }
        }
        catch (Exception e) {
            log.info("deal cross domain has exception : ", (Throwable)e);
        }
        customFilterChain.filter(httpRequest, response);
    }

    private void dealOptionRequest(KjjHttpRequest httpRequest, KjjHttpResponse response) {
        URI uri;
        String host;
        String origin = httpRequest.getHeader(HttpHeaderNames.ORIGIN.toString());
        log.info("\u6765\u5566\uff0c\u6765\u5566 uri={}", (Object)httpRequest.getRequestURI());
        if (StringUtils.isBlank((CharSequence)origin)) {
            origin = httpRequest.getHeader(HttpHeaderNames.REFERER.toString());
        }
        if (this.isAllowDomain(host = (uri = URI.create(origin)).getHost())) {
            if (SpringEnvironmentUtils.isTestEnv() || SpringEnvironmentUtils.isDevEnv()) {
                response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
            } else {
                response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, uri.getScheme() + "://" + host);
            }
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, "POST, GET, OPTIONS");
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, "3600");
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.allowHeads);
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            response.flushAndClose();
        }
    }

    private boolean isAllowDomain(String host) {
        if (this.domains.contains(host)) {
            return true;
        }
        if (host.contains(".")) {
            String subHost = host.substring(host.indexOf(".") + 1);
            return this.isAllowDomain(subHost);
        }
        return false;
    }
}

