/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.fitler;

import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class MonitorWebFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        URI uri = exchange.getRequest().getURI();
        String requestPath = uri.getPath();
        if (requestPath.equals("/monitor/check")) {
            return this.writeMsg(exchange, "ok");
        }
        if (requestPath.equals("/monitor/stop")) {
            return this.writeMsg(exchange, "ok");
        }
        if (requestPath.equals("/monitor/start")) {
            return this.writeMsg(exchange, "ok");
        }
        return chain.filter(exchange);
    }

    private Mono<Void> writeMsg(ServerWebExchange exchange, String msg) {
        ServerHttpResponse response = exchange.getResponse();
        DataBuffer buffer = response.bufferFactory().wrap(msg.getBytes());
        Mono just = Mono.just((Object)buffer);
        return response.writeWith((Publisher)just);
    }
}

