/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.enums;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.wolf.utils.UrlUtils2;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProviderChannelEnum {
    WECHAT_OA(1, "/oax", "\u4e2a\u5fae\u516c\u4f17\u53f7"),
    WX_WORK(2, "/qywx", "\u4f01\u5fae\u5e94\u7528"),
    THIRD_PARTY_APP(3, "/app", "\u7b2c\u4e09\u65b9APP");

    private static final Logger log;
    private final Integer code;
    private final String urlPrefix;
    private final String desc;
    private static final Map<Integer, ProviderChannelEnum> ENUM_MAP;

    private ProviderChannelEnum(Integer code, String urlPrefix, String desc) {
        this.code = code;
        this.urlPrefix = urlPrefix;
        this.desc = desc;
    }

    public static ProviderChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getUrl(String channelId, String subUrl) {
        if (StringUtils.isBlank((String)channelId)) {
            return subUrl;
        }
        return this.urlPrefix + "/" + channelId + subUrl;
    }

    public String getUrl(Long channelId, String subUrl) {
        if (Objects.isNull(channelId)) {
            return subUrl;
        }
        return this.urlPrefix + "/" + IdMakeUtil.encodingId(channelId) + subUrl;
    }

    public String autoJoinChannel(Long channelId, String subUrl, String serverDomain) {
        return this.doJoinUrl(serverDomain, subUrl, IdMakeUtil.encodingId(channelId));
    }

    public String autoJoinChannel(String channelMarking, String subUrl, String serverDomain) {
        return this.doJoinUrl(serverDomain, subUrl, channelMarking);
    }

    @NotNull
    private String doJoinUrl(String serverDomain, String url, String channelMarking) {
        if (StringUtils.isBlank((String)url)) {
            url = "/";
        }
        URI uri = URI.create(url);
        StringBuilder formatUri = new StringBuilder();
        this.appendServer(serverDomain, uri, formatUri);
        Map<String, String> channelParam = this.appendChannel2PathOrBuildChannelParam(channelMarking, uri, formatUri);
        return this.appendQuery(uri, formatUri, channelParam);
    }

    private String appendQuery(URI uri, StringBuilder formatUri, Map<String, String> channelParam) {
        String redirectUrl = formatUri.toString();
        if (StringUtils.isBlank((String)uri.getRawQuery())) {
            if (MapUtils.isNotEmpty(channelParam)) {
                return UrlUtils2.appendParams((String)redirectUrl, channelParam);
            }
            return redirectUrl;
        }
        Map queryMap = UrlUtils2.extractUrlParams((String)uri.getRawQuery());
        queryMap.putAll(channelParam);
        return UrlUtils2.appendParams((String)redirectUrl, (Map)queryMap);
    }

    private Map<String, String> appendChannel2PathOrBuildChannelParam(String channelMarking, URI uri, StringBuilder formatUri) {
        HashMap<String, String> extParam = new HashMap<String, String>();
        String rawPath = this.getPath(uri.getRawPath());
        if (StringUtils.isBlank((String)channelMarking)) {
            formatUri.append(rawPath);
        } else if (StringUtils.startsWith((String)rawPath, (String)"/kjj/jump")) {
            String prefix = ProviderChannelEnum.getByCode(this.getCode()).getUrl(channelMarking, "");
            Map queryMap = UrlUtils2.extractUrlParams((String)uri.getRawQuery());
            if (!queryMap.containsKey("urlPrefix")) {
                extParam.put("urlPrefix", prefix);
            }
            formatUri.append(rawPath);
        } else if (StringUtils.startsWith((String)rawPath, (String)"/pages") || StringUtils.startsWith((String)rawPath, (String)"/basic")) {
            String path = ProviderChannelEnum.getByCode(this.getCode()).getUrl(channelMarking, rawPath);
            formatUri.append(path);
        } else if (StringUtils.startsWith((String)rawPath, (String)this.urlPrefix)) {
            formatUri.append(rawPath);
        } else {
            formatUri.append(rawPath);
            extParam.put("channelMarking", channelMarking);
        }
        return extParam;
    }

    private void appendServer(String serverDomain, URI uri, StringBuilder formatUri) {
        if (StringUtils.isBlank((String)uri.getHost())) {
            if (StringUtils.isNotBlank((String)serverDomain)) {
                formatUri.append(serverDomain);
            }
        } else {
            if (StringUtils.isNotBlank((String)uri.getScheme())) {
                formatUri.append(uri.getScheme());
                formatUri.append("://");
            } else {
                formatUri.append("https://");
            }
            formatUri.append(uri.getHost());
        }
    }

    private String getPath(String path) {
        if (StringUtils.equals((String)"/", (String)path)) {
            return "/kjj/jump?sense=1";
        }
        return path;
    }

    public static void main(String[] args) {
        String pushUrl;
        String webUrl2;
        String webUrl;
        String homeJump2;
        String homeJump;
        String homePage2;
        String homePage;
        String serverDomain2;
        String serverDomain = WECHAT_OA.autoJoinChannel(1L, "https://wx.kjjcrm.com/basic/pages/home/index?tab=202", "https://wx.kjjcrm.com");
        if (!StringUtils.equals((String)serverDomain, (String)"https://wx.kjjcrm.com/oax/Kj21MTU/basic/pages/home/index?tab=202")) {
            System.err.println("\u57df\u540d\u8ffd\u52a0\u9519\u8bef" + serverDomain);
        }
        if (!StringUtils.equals((String)(serverDomain2 = WECHAT_OA.autoJoinChannel(1L, "https://wx.kjjcrm.com/basic/pages/home/index?tab=202", null)), (String)"https://wx.kjjcrm.com/oax/Kj21MTU/basic/pages/home/index?tab=202")) {
            System.err.println("\u57df\u540d\u8ffd\u52a0\u9519\u8bef" + serverDomain2);
        }
        if (!StringUtils.equals((String)(homePage = WECHAT_OA.autoJoinChannel(1L, "/basic/pages/home/index?tab=202", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/oax/Kj21MTU/basic/pages/home/index?tab=202")) {
            System.err.println("\u9996\u9875H5\u5730\u5740\u62fc\u63a5\u9519\u8bef" + homePage);
        }
        if (!StringUtils.equals((String)homePage, (String)serverDomain2)) {
            System.err.println("\u57df\u540d\u8ffd\u52a0\u9519\u8bef");
        }
        if (!StringUtils.equals((String)serverDomain2, (String)serverDomain)) {
            System.err.println("\u57df\u540d\u8ffd\u52a0\u9519\u8bef");
        }
        if (!StringUtils.equals((String)(homePage2 = WECHAT_OA.autoJoinChannel(1L, "/oax/Kj21MTU/basic/pages/home/index?tab=202", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/oax/Kj21MTU/basic/pages/home/index?tab=202")) {
            System.err.println("\u9996\u9875H5\u9644\u5e26\u6e20\u9053\u540e\u7684\u5730\u5740\u62fc\u63a5\u9519\u8bef" + homePage2);
        }
        if (!StringUtils.equals((String)(homeJump = WECHAT_OA.autoJoinChannel(1L, "/kjj/jump?sense=1&access_source=31", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/kjj/jump?urlPrefix=/oax/Kj21MTU&sense=1&access_source=31")) {
            System.err.println("\u9996\u9875\u4e8c\u8df3\u5730\u5740\u9519\u8bef" + homeJump);
        }
        if (!StringUtils.equals((String)(homeJump2 = WECHAT_OA.autoJoinChannel(1L, "/kjj/jump?sense=1&urlPrefix=/oax/Kj21MTU&access_source=31", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/kjj/jump?urlPrefix=/oax/Kj21MTU&sense=1&access_source=31")) {
            System.err.println("\u9996\u9875\u4e8c\u8df3\u9644\u5e26\u6e20\u9053\u540e\u7684\u5730\u5740\u9519\u8bef" + homeJump2);
        }
        if (!StringUtils.equals((String)(webUrl = WECHAT_OA.autoJoinChannel(1L, "/kjy/mp/content?&access_source=31", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/kjy/mp/content?channelMarking=Kj21MTU&access_source=31")) {
            System.err.println("\u540e\u7aef\u63a5\u53e3\u5730\u5740\u62fc\u63a5\u9519\u8bef" + webUrl);
        }
        if (!StringUtils.equals((String)(webUrl2 = WECHAT_OA.autoJoinChannel(1L, "/kjy/mp/content?&access_source=31&channelMarking=Kj21MTU", "https://wx.kjjcrm.com")), (String)"https://wx.kjjcrm.com/kjy/mp/content?channelMarking=Kj21MTU&access_source=31")) {
            System.err.println("\u540e\u7aef\u63a5\u53e3\u9644\u5e26\u6e20\u9053\u540e\u7684\u5730\u5740\u62fc\u63a5\u9519\u8bef" + webUrl2);
        }
        if (!StringUtils.equals((String)(pushUrl = WECHAT_OA.autoJoinChannel(1L, "https://kjj.m.duibatest.com.cn/kjy/mp/seller/push/auto?&redirectUrl=%2Fpages%2Farticle%2F%E3%80%90scid%E3%80%91&push_biz_id=2&url_order=1&cid=Kj21NzU2NjM&u_m=zHD3OipvTACRubnIJ6xsng", "https://kjj.m.duibatest.com.cn")), (String)"https://kjj.m.duibatest.com.cn/kjy/mp/seller/push/auto?u_m=zHD3OipvTACRubnIJ6xsng&channelMarking=Kj21MTU&redirectUrl=%2Fpages%2Farticle%2F%E3%80%90scid%E3%80%91&url_order=1&push_biz_id=2&cid=Kj21NzU2NjM")) {
            System.err.println("\u63a8\u9001\u63a5\u53e3\u5730\u5740\u62fc\u63a5\u9519\u8bef" + pushUrl);
        }
        String pushUrl2 = WECHAT_OA.autoJoinChannel(1L, "/kjy/mp/seller/push/auto?channelMarking=12312&redirectUrl=%2Fpages%2Farticle%2F%E3%80%90scid%E3%80%91&push_biz_id=2&url_order=1&cid=Kj21NzU2NjM&u_m=zHD3OipvTACRubnIJ6xsng", "https://kjj.m.duibatest.com.cn");
        if (!StringUtils.equals((String)pushUrl, (String)"https://kjj.m.duibatest.com.cn/kjy/mp/seller/push/auto?u_m=zHD3OipvTACRubnIJ6xsng&channelMarking=Kj21MTU&redirectUrl=%2Fpages%2Farticle%2F%E3%80%90scid%E3%80%91&url_order=1&push_biz_id=2&cid=Kj21NzU2NjM")) {
            System.err.println("\u63a8\u9001\u63a5\u53e3\u9644\u5e26\u6e20\u9053\u540e\u7684\u5730\u5740\u62fc\u63a5\u9519\u8bef" + pushUrl2);
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(ProviderChannelEnum.class);
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ProviderChannelEnum.values()).collect(Collectors.toMap(ProviderChannelEnum::getCode, Function.identity(), (v1, v2) -> {
            log.error("ProviderChannelEnum, type distinct, type={}", (Object)v2.getCode());
            return v2;
        })));
    }
}

