/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginUtil.class);

    private LoginUtil() {
    }

    public static <T extends Serializable> String createCookieValue(T dto, String keyEncrypt) {
        if (dto == null || StringUtils.isBlank((CharSequence)keyEncrypt)) {
            return null;
        }
        try {
            String value = JSON.toJSONString(dto);
            return BlowfishUtils.encryptBlowfish((String)value, (String)keyEncrypt);
        }
        catch (Exception e) {
            log.error("LoginUtil, get cookie value error, dto={}, keyEncrypt={}", new Object[]{dto, keyEncrypt, e});
            return null;
        }
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = LoginUtil.getOneCookieByName(request, cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public static <T extends Serializable> T decodeCookie(String cookieValue, String keyEncrypt, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)cookieValue) || StringUtils.isBlank((CharSequence)keyEncrypt) || clazz == null) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)cookieValue, (String)keyEncrypt);
            return (T)((Serializable)JSON.parseObject((String)content, clazz));
        }
        catch (Exception e) {
            log.error("LoginUtil, decode cookie error, cookieValue={}, keyEncrypt={}, className={}", new Object[]{cookieValue, keyEncrypt, clazz.getName(), e});
            return null;
        }
    }

    public static boolean addOrUpdateCookie(HttpServletRequest request, HttpServletResponse response, List<String> domains, String cookieName, String cookieValue, int expiredDays) {
        if (request == null || response == null || CollectionUtils.isEmpty(domains) || StringUtils.isBlank((CharSequence)cookieName) || StringUtils.isBlank((CharSequence)cookieValue) || expiredDays < 1) {
            log.error("LoginUtil, addCookie param error, cookieName={}, cookieValue={}, expiredDays={}, domains.size={}", new Object[]{cookieName, cookieValue, expiredDays, domains == null ? 0 : domains.size()});
            return false;
        }
        try {
            LoginUtil.doAddOrUpdateCookie(request, response, domains, cookieName, cookieValue, expiredDays);
            return true;
        }
        catch (Exception e) {
            log.error("LoginUtil, addCookie error, cookieName={}, cookieValue={}, expiredDays={}, domains.size={}, e:", new Object[]{cookieName, cookieValue, expiredDays, domains.size(), e});
            domains.forEach(domain -> log.error("LoginUtil, doLoginCookie error, domain={}", domain));
            return false;
        }
    }

    public static boolean cleanCookie(HttpServletRequest request, HttpServletResponse response, List<String> domains, String cookieName) {
        if (request == null || response == null || CollectionUtils.isEmpty(domains) || StringUtils.isBlank((CharSequence)cookieName)) {
            log.error("LoginUtil, cleanCookie param error, cookieName={}, domains.size={}", (Object)cookieName, (Object)(domains == null ? 0 : domains.size()));
            return false;
        }
        try {
            LoginUtil.doUpdateCookie(request, response, domains, cookieName, null, 0);
            return true;
        }
        catch (Exception e) {
            log.error("LoginUtil, cleanCookie error, cookieName={}, domains.size={}, e:", new Object[]{cookieName, domains.size(), e});
            domains.forEach(domain -> log.error("LoginUtil, cleanCookie error, domain={}", domain));
            return false;
        }
    }

    private static void doAddOrUpdateCookie(HttpServletRequest request, HttpServletResponse response, List<String> domains, String cookieName, String cookieValue, int expiredDays) {
        int maxAge = expiredDays * 24 * 60 * 60;
        boolean updateResult = LoginUtil.doUpdateCookie(request, response, domains, cookieName, cookieValue, maxAge);
        if (updateResult) {
            return;
        }
        Cookie userCookie = new Cookie(cookieName, cookieValue);
        LoginUtil.fillCookie(userCookie, maxAge);
        domains.forEach(domain -> LoginUtil.addCookie(response, userCookie, domain));
        if (SpringEnvironmentUtils.isProdEnv()) {
            return;
        }
        response.addHeader(cookieName, cookieValue);
    }

    private static boolean doUpdateCookie(HttpServletRequest request, HttpServletResponse response, List<String> domains, String cookieName, String cookieValue, int maxAge) {
        List<Cookie> cookieList = LoginUtil.getCookieByName(request, cookieName);
        if (CollectionUtils.isEmpty(cookieList)) {
            return false;
        }
        cookieList.forEach(cookie -> LoginUtil.doUpdateCookie(response, cookie, domains, cookieValue, maxAge));
        return true;
    }

    private static Cookie getOneCookieByName(HttpServletRequest request, String cookieName) {
        List<Cookie> cookieList = LoginUtil.getCookieByName(request, cookieName);
        if (CollectionUtils.isEmpty(cookieList)) {
            return null;
        }
        return cookieList.get(cookieList.size() - 1);
    }

    private static List<Cookie> getCookieByName(HttpServletRequest request, String cookieName) {
        if (request == null) {
            return Collections.emptyList();
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(cookies).filter(cookie -> StringUtils.equals((CharSequence)cookie.getName(), (CharSequence)cookieName)).collect(Collectors.toList());
    }

    private static void doUpdateCookie(HttpServletResponse response, Cookie cookie, List<String> domains, String cookieValue, int maxAge) {
        LoginUtil.fillCookie(cookie, maxAge, cookieValue);
        domains.forEach(domain -> LoginUtil.addCookie(response, cookie, domain));
    }

    private static void addCookie(HttpServletResponse response, Cookie cookie, String domain) {
        cookie.setDomain(domain);
        response.addCookie(cookie);
    }

    private static void fillCookie(Cookie cookie, int maxAge) {
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        cookie.setMaxAge(maxAge);
    }

    private static void fillCookie(Cookie cookie, int maxAge, String cookieValue) {
        LoginUtil.fillCookie(cookie, maxAge);
        cookie.setValue(cookieValue);
    }
}

