/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.wolf.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final Pattern PHONE_PATTERN = Pattern.compile("(1|861)((3[0-9])|(5[^4,\\D])|(8[0,5-9]))\\d{8}$*");

    private StringUtil() {
    }

    public static String masking(String str, int prefix, int suffix, boolean onlyOne) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        int temp = prefix + suffix;
        int length = StringUtils.length((CharSequence)str);
        if (length <= temp) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.substring(0, prefix));
        int needSize = onlyOne ? 1 : length - temp;
        for (int j = 0; j < needSize; ++j) {
            builder.append("*");
        }
        builder.append(str, length - suffix, length);
        return builder.toString();
    }

    public static List<String> getPhoneNum(String str) {
        ArrayList<String> result = new ArrayList<String>(4);
        if (str == null || str.length() <= 0) {
            return result;
        }
        Matcher matcher = PHONE_PATTERN.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static String maskingPhoneForLog(String phone) {
        return StringUtil.masking(phone, 3, 4, true);
    }

    public static String maskingPhone(String phone) {
        return StringUtil.masking(phone, 3, 4, false);
    }

    public static String maskingAllPhone(String str, boolean onlyOne) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        List<String> list = StringUtil.getPhoneNum(str);
        if (CollectionUtils.isEmpty(list)) {
            return str;
        }
        for (String s : list) {
            str = str.replaceAll(s, StringUtil.masking(s, 3, 4, onlyOne));
        }
        return str;
    }

    public static String subStringIfAbsent(String str, int maxLength) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    public static List<Long> splitParseLong(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.emptyList();
        }
        String[] ids = str.split(",");
        return Arrays.stream(ids).map(StringUtil::parseLong).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Long parseLong(String str) {
        if (StringUtils.isBlank((CharSequence)str) || !NumberUtils.isNumeric((String)str)) {
            return null;
        }
        return Long.valueOf(str);
    }
}

