/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.LoginBean;
import cn.com.duiba.kjy.base.api.bean.login.LoginConstant;
import cn.com.duiba.kjy.base.exception.KjjBaseException;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String encodeToken(LoginBean loginBean) {
        if (Objects.isNull(loginBean)) {
            return null;
        }
        loginBean.setDisableTime(DateUtils.addDays((Date)new Date(), (int)LoginConstant.LOGIN_CKE_MP_EXPIRY_DAYS).getTime());
        loginBean.setTime(loginBean.getDisableTime());
        try {
            return BlowfishUtils.encryptBlowfish((String)objectMapper.writeValueAsString((Object)loginBean), (String)"89a1657cb6a3");
        }
        catch (JsonProcessingException e) {
            throw new KjjBaseException(BaseErrorCode.JACKSON_SERIALIZABLE);
        }
    }

    public static <T extends LoginBean> T decodeToken(String value, Class<T> clazz) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            String decodeStr = BlowfishUtils.decryptBlowfish((String)value, (String)"89a1657cb6a3");
            return (T)((LoginBean)objectMapper.readValue(decodeStr, clazz));
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6token\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

