/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.exception.ExceptionHandlerException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ControllerAdviceHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.DefaultExceptionHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ResponseStatusExceptionHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.web.method.ControllerAdviceBean;

public class ExceptionChain
extends ApplicationObjectSupport {
    private static final Logger log = LoggerFactory.getLogger(ExceptionChain.class);
    @Resource
    private DefaultExceptionHandler defaultExceptionHandler;
    private final LinkedList<ExceptionHandler> exceptionHandlerList = new LinkedList();
    @Resource
    private ObjectMapper objectMapper;

    public ExceptionChain(List<ExceptionHandler> handlerList) {
        this.exceptionHandlerList.addAll(handlerList);
    }

    @PostConstruct
    public void init() {
        List annotatedBeans = ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)this.getApplicationContext());
        this.exceptionHandlerList.addFirst(new ControllerAdviceHandler(annotatedBeans, this.objectMapper));
        this.exceptionHandlerList.addFirst(new ResponseStatusExceptionHandler());
    }

    public void handlerException(KjjHttpRequest request, KjjHttpResponse response, Throwable e) {
        try {
            for (ExceptionHandler exceptionHandler : this.exceptionHandlerList) {
                if (!exceptionHandler.doHandler(request, response, e)) continue;
                return;
            }
        }
        catch (Exception e2) {
            this.defaultExceptionHandler.doHandler(request, response, new ExceptionHandlerException(e, e2));
        }
    }
}

