/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.request;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 5033472050991731743L;
    private Integer pageIndex;
    private Integer pageSize;
    private Long totalCount;
    private List<T> list;
    private Boolean hasNext;

    public Boolean getHasNext() {
        Long totalPage;
        if (Objects.isNull(this.hasNext) && Objects.nonNull(totalPage = this.getTotalPage())) {
            return totalPage - (long)this.pageIndex.intValue() > 0L;
        }
        return this.hasNext;
    }

    public Long getTotalPage() {
        if (Objects.nonNull(this.pageIndex) && Objects.nonNull(this.totalCount) && Objects.nonNull(this.pageSize)) {
            return this.totalCount / (long)this.pageSize.intValue() + (long)(this.totalCount % (long)this.pageSize.intValue() > 0L ? 1 : 0);
        }
        return null;
    }

    public static <T> PageResult<T> init(Integer pageIndex, Integer pageSize) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setList(Lists.newArrayList());
        pageResult.setTotalCount(0L);
        pageResult.setPageIndex(pageIndex);
        pageResult.setPageSize(pageSize);
        return pageResult;
    }

    public static <T> PageResult<T> getNoNextResult() {
        PageResult pageResult = new PageResult();
        pageResult.setList(Collections.emptyList());
        pageResult.setHasNext(false);
        return pageResult;
    }

    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public static <T> PageResult<T> copyPage(PageResult<?> sourcePage, Class<T> destClz) {
        if (sourcePage == null) {
            return null;
        }
        PageResult<T> result = PageResult.init(sourcePage.getPageIndex(), sourcePage.getPageSize());
        if (destClz == null) {
            return result;
        }
        List destList = BeanUtils.copyList(sourcePage.getList(), destClz);
        result.setList(destList);
        result.setTotalCount(sourcePage.getTotalCount());
        return result;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Boolean this$hasNext = this.getHasNext();
        Boolean other$hasNext = other.getHasNext();
        return !(this$hasNext == null ? other$hasNext != null : !((Object)this$hasNext).equals(other$hasNext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Boolean $hasNext = this.getHasNext();
        result = result * 59 + ($hasNext == null ? 43 : ((Object)$hasNext).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", totalCount=" + this.getTotalCount() + ", list=" + this.getList() + ", hasNext=" + this.getHasNext() + ")";
    }
}

