/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.codec.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.web.codec.IdDecode;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class IdDecodeConvert
implements ConditionalGenericConverter {
    private static final Logger log = LoggerFactory.getLogger(IdDecodeConvert.class);

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Long.class));
    }

    public Object convert(Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (source instanceof String) {
            String sourceString = (String)source;
            return this.decodeId(sourceString);
        }
        log.error("can not convert target={} to Long.class", source);
        return null;
    }

    @Nullable
    private Long decodeId(String sourceString) {
        Long id = IdMakeUtil.decodingId(sourceString);
        if (Objects.isNull(id) && StringUtils.isNotBlank((String)sourceString)) {
            return null;
        }
        return id;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(IdDecode.class);
    }
}

