/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.processor;

import cn.com.duiba.kjy.base.customweb.autoconfig.EnableKjjNettyServer;
import cn.com.duibaboot.ext.autoconfigure.data.redis.DuibaRedisCondition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class KjjEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @VisibleForTesting
    public static final Map<String, String> defProperties;
    @VisibleForTesting
    public static final String DUIBA_BOOT_DEFAULT_CONFIG = "duibaBootDefaultConfig";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Class mainClass = application.getMainApplicationClass();
        if (Objects.isNull(mainClass) || !mainClass.isAnnotationPresent(EnableKjjNettyServer.class)) {
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(defProperties);
        MapPropertySource propertySource = new MapPropertySource(DUIBA_BOOT_DEFAULT_CONFIG, properties);
        environment.getPropertySources().addLast((PropertySource)propertySource);
        this.configRedisProperties(environment, properties);
        this.configEurekaProperties(environment, properties);
    }

    private void configRedisProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        String property = "spring.autoconfigure.exclude";
        String excludeAutoConfigClasses = StringUtils.defaultString((String)environment.getProperty(property), null);
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)excludeAutoConfigClasses)) {
            excludeList.add(excludeAutoConfigClasses);
        }
        excludeList.add(RedisAutoConfiguration.class.getName());
        excludeList.add("org.springframework.boot.actuate.autoconfigure.hazelcast.HazelcastHealthContributorAutoConfiguration");
        excludeList.add("org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration");
        excludeAutoConfigClasses = Joiner.on((String)",").skipNulls().join(excludeList);
        properties.put(property, excludeAutoConfigClasses);
        if (!DuibaRedisCondition.isRedisAutoConfigEnable((Environment)environment)) {
            properties.put("spring.data.redis.repositories.enabled", "false");
        }
    }

    private void configEurekaProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        String contextPath = environment.getProperty("server.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = environment.getProperty("server.contextPath");
        }
        if (!StringUtils.isBlank((CharSequence)contextPath)) {
            properties.put("eureka.instance.home-page-url-path", contextPath);
        }
    }

    static {
        HashMap<String, String> overrideProperties = new HashMap<String, String>();
        overrideProperties.put("spring.metrics.servo.enabled", "false");
        overrideProperties.put("spring.metrics.export.enabled", "false");
        overrideProperties.put("ribbon.eager-load.enabled", "true");
        overrideProperties.put("management.health.elasticsearch.enabled", "false");
        overrideProperties.put("management.health.mail.enabled", "false");
        overrideProperties.put("management.health.cassandra.enabled", "false");
        overrideProperties.put("management.health.couchbase.enabled", "false");
        overrideProperties.put("management.health.mongo.enabled", "false");
        overrideProperties.put("management.health.rabbit.enabled", "false");
        overrideProperties.put("management.health.redis.enabled", "false");
        overrideProperties.put("management.health.solr.enabled", "false");
        overrideProperties.put("management.health.hazelcast.enabled", "false");
        overrideProperties.put("spring.http.encoding.force", "true");
        overrideProperties.put("spring.zipkin.sender.type", "web");
        overrideProperties.put("spring.cloud.service-registry.auto-registration.enabled", "false");
        overrideProperties.put("server.error.include-exception", "true");
        overrideProperties.put("management.endpoints.web.exposure.include", "*");
        overrideProperties.put("spring.sleuth.baggage-keys", "X-B3-Flags");
        overrideProperties.put("spring.jackson.serialization.write-dates-as-timestamps", "true");
        overrideProperties.put("server.use-forward-headers", "true");
        overrideProperties.put("spring.cloud.refresh.refreshable", "");
        overrideProperties.put("eureka.client.refresh.enable", "false");
        overrideProperties.put("spring.cloud.refresh.never-refreshable", "com.zaxxer.hikari.HikariDataSource,cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSourceForHikari,org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory");
        defProperties = Collections.unmodifiableMap(overrideProperties);
    }
}

