/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlSecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(TlSecurityUtil.class);
    private static final String TAI_LONG_APP_ID = "7428f510-4187-4169-b359-a9295fcc6b23";
    private static final String PUBLIC_KEY = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE/knoPfu5Dyzevnuxt/W8R3KGZuvzCJz5CTAJkqoWepnpjI2Ar5Q4Ba8y0Qo0WXmUPOd8IQ/kDEPqe43fMtErCg==";
    private static final String PRIVATE_KEY = "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgG9IbK5uambvQpn7A47CvmZVbjyD054WVMU/PuB1vje2gCgYIKoEcz1UBgi2hRANCAATe8Z/6BFSMDnIppQUYhbB7B/6Gh7rwXakCQmLs2pMjl587D8SiKdq2HRTRFCIu57uYAU75MfLMfTV6ODUfasVJ";
    private static final String APP_SECRET_KEY = "d23b90de-63ae-4325-bf77-7cfa38cac1ef";
    private static final String SUCCESS_CODE = "000000";

    private TlSecurityUtil() {
    }

    public static String parseParamRspData(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return param;
        }
        try {
            JSONObject json = JSON.parseObject((String)param);
            return TlSecurityUtil.parseResult(json, json.getString("appAccessToken"), false, false);
        }
        catch (Exception e) {
            log.error("TlSecurityUtil, param={}", (Object)param, (Object)e);
            return param;
        }
    }

    public static String getAccessToken(String url) {
        return TlSecurityUtil.callTl(url, "approveDev", null, null, true);
    }

    public static String callBiz(String url, String serviceId, String reqData, String accessToken) {
        return TlSecurityUtil.callTl(url, serviceId, reqData, accessToken, false);
    }

    public static String buildReqParam(String reqData, String accessToken) {
        try {
            JSONObject param = TlSecurityUtil.getParam(reqData, accessToken, false);
            return param.toJSONString();
        }
        catch (Exception e) {
            log.error("TlSecurityUtil, buildReqParam, reqData={}, accessToken={}", (Object)reqData, (Object)accessToken);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String callTl(String url, String serviceId, String reqData, String accessToken, boolean isToken) {
        String string;
        String rspData = null;
        try {
            string = rspData = TlSecurityUtil.doCallTl(url, serviceId, reqData, accessToken, isToken);
        }
        catch (Exception e) {
            String string2;
            try {
                log.error("TlSecurityUtil, serviceId={}, reqData={}, accessToken={}, isToken={}", new Object[]{serviceId, reqData, accessToken, isToken});
                string2 = null;
            }
            catch (Throwable throwable) {
                log.info("TlSecurityUtil, response data, serviceId={}, reqData={}, accessToken={}, isToken={}, rspData={}", new Object[]{serviceId, reqData, accessToken, isToken, rspData});
                throw throwable;
            }
            log.info("TlSecurityUtil, response data, serviceId={}, reqData={}, accessToken={}, isToken={}, rspData={}", new Object[]{serviceId, reqData, accessToken, isToken, rspData});
            return string2;
        }
        log.info("TlSecurityUtil, response data, serviceId={}, reqData={}, accessToken={}, isToken={}, rspData={}", new Object[]{serviceId, reqData, accessToken, isToken, rspData});
        return string;
    }

    private static String doCallTl(String url, String serviceId, String reqData, String accessToken, boolean isToken) throws Exception {
        JSONObject param = TlSecurityUtil.getParam(reqData, accessToken, isToken);
        log.info("TlSecurityUtil, getParam, serviceId={}, reqData={}, accessToken={}, isToken={}, param={}", new Object[]{serviceId, reqData, accessToken, isToken, param});
        String rspMsg = TlSecurityUtil.doPost(param, url + serviceId);
        log.info("TlSecurityUtil, response, url={}, reqData={}, accessToken={}, isToken={}, param={}, rspMsg={}", new Object[]{url + serviceId, reqData, accessToken, isToken, param, rspMsg});
        return TlSecurityUtil.parseResult(rspMsg, accessToken, isToken);
    }

    private static JSONObject getParam(String reqData, String accessToken, boolean isToken) throws Exception {
        String seqNo = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
        if (!isToken) {
            return TlSecurityUtil.getSignParam(reqData, accessToken, false, seqNo);
        }
        String random = MD5Util.md5_((String)seqNo);
        JSONObject param = TlSecurityUtil.getSignParam(random, accessToken, true, seqNo);
        param.put("random", (Object)random);
        return param;
    }

    private static JSONObject getSignParam(String data, String accessToken, boolean isToken, String seqNo) throws Exception {
        JSONObject param = new JSONObject();
        param.put("appID", (Object)TAI_LONG_APP_ID);
        param.put("seqNO", (Object)seqNo);
        String randomKey = MD5Util.md5_((String)UUID.randomUUID().toString());
        param.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey((String)randomKey, (String)PUBLIC_KEY));
        param.put("sm2Sign", (Object)SM2Util.signByPrivateKey((String)randomKey, (String)PRIVATE_KEY, (String)TAI_LONG_APP_ID));
        param.put("sign", (Object)SM3Util.sign((String)(data + seqNo + APP_SECRET_KEY + randomKey)));
        if (isToken) {
            return param;
        }
        param.put("signMethod", (Object)"SM3");
        param.put("encryptMethod", (Object)"SM4");
        param.put("appAccessToken", (Object)accessToken);
        param.put("reqData", (Object)SM4Util.encrypt((String)data, (String)(seqNo + accessToken + APP_SECRET_KEY + randomKey)));
        return param;
    }

    private static String doPost(JSONObject param, String url) throws IOException {
        String msg = param.toJSONString();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg.getBytes());
        httpPost.setEntity((HttpEntity)bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    private static String parseResult(String rspMsg, String accessToken, boolean isToken) throws Exception {
        JSONObject rspJsonObj = JSON.parseObject((String)rspMsg);
        String errorCode = rspJsonObj.getString("errorCode");
        if (!SUCCESS_CODE.equals(errorCode) && isToken) {
            log.info("TlSecurityUtil, code error, rspMsg={}", (Object)rspMsg);
            return null;
        }
        return TlSecurityUtil.parseResult(rspJsonObj, accessToken, isToken, true);
    }

    private static String parseResult(JSONObject json, String accessToken, boolean isToken, boolean isRsp) throws Exception {
        String randomKey = SM2Util.decryptByPrivateKey((String)json.getString("sm2EncryptData"), (String)PRIVATE_KEY);
        boolean sm2Sign = SM2Util.verifyByPublicKey((String)json.getString("sm2Sign"), (String)PUBLIC_KEY, (String)TAI_LONG_APP_ID, (String)randomKey);
        if (!sm2Sign) {
            log.info("TlSecurityUtil, sm2 sign error, json={}, randomKey={}", (Object)json.toJSONString(), (Object)randomKey);
            return null;
        }
        String seqNo = json.getString("seqNO");
        if (isToken) {
            return TlSecurityUtil.parseToken(json, randomKey, seqNo);
        }
        return TlSecurityUtil.parseBiz(json, accessToken, randomKey, seqNo, isRsp);
    }

    private static String parseToken(JSONObject rspJsonObj, String randomKey, String seqNo) {
        boolean verify = SM3Util.verify((String)(rspJsonObj.getString("random") + seqNo + randomKey + APP_SECRET_KEY), (String)rspJsonObj.getString("sign"));
        if (!verify) {
            log.info("TlSecurityUtil, get token, sm3 sign error, rspMsg={}, randomKey={}", (Object)rspJsonObj.toJSONString(), (Object)randomKey);
            return null;
        }
        return randomKey;
    }

    private static String parseBiz(JSONObject json, String accessToken, String randomKey, String seqNo, boolean isRsp) {
        String data = isRsp ? json.getString("rspData") : json.getString("reqData");
        String rspData = SM4Util.decrypt((String)data, (String)(seqNo + accessToken + APP_SECRET_KEY + randomKey));
        boolean verify = SM3Util.verify((String)(rspData + seqNo + APP_SECRET_KEY + randomKey), (String)json.getString("sign"));
        if (!verify) {
            log.info("TlSecurityUtil, sm3 sign error, json={}, randomKey={}, accessToken={}", new Object[]{json.toJSONString(), randomKey, accessToken});
            return null;
        }
        return rspData;
    }
}

