package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.entity.ContentType;
import org.springframework.core.annotation.Order;

/**
 * @author dugq
 * @date 2021/3/28 11:04 下午
 */
@Order
@Slf4j
public class DefaultExceptionHandler implements ExceptionHandler{

    @Override
    public boolean doHandler(KjjHttpRequest request, KjjHttpResponse response, Throwable th) {
        log.error("",th);
        if (response.isClosed()){
            return true;
        }
        response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
        response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        response.write(th.toString());
        response.flushAndClose();
        return true;
    }
}
