package cn.com.duiba.kjy.base.reactive.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * Created by dugq on 2019-10-24.
 */
@Slf4j
public class IdDecodeBean {


    protected Long decodeId(IdDecode parameterAnnotation, String value, Class<?> parameterType, String filedName) {    //NOSONAR
        if(StringUtils.isBlank(value)){
            return null;
        }
        try {
            return IdMakeUtil.decodingId(value);
        }catch (Exception e){
            log.error("id ILLEGAL1",e);
            return null;
        }

//        if(Objects.isNull(id) && (StringUtils.isNotBlank(value) || parameterType.isPrimitive())){
//            HttpServletRequest request = getRequest();
//            log.info("id ILLEGAL; url = {} \n Referer = {} \n hash-path = {} \n 非法参数： {} = {} \n ",
//                    request.getRequestURI(),request.getHeader("Referer"),request.getHeader("W-Hash-Path"),filedName,value);
//            throw new KjyLiveIndexWebException(ErrorCode.ILLEGAL_ID);
//        }
    }


    protected boolean isPrimitiveOrString(Class<?> parameterType) {
        return parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType) || parameterType.equals(String.class);
    }
    protected Boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }
    protected Boolean isCollection(Class<?> parameterType) {
        return List.class.isAssignableFrom(parameterType) || Set.class.isAssignableFrom(parameterType);
    }

    protected List<Field> getAllFields(Class clazz) {
        if(Objects.isNull(clazz) || clazz.isInterface()){
            return Collections.emptyList();
        }
        List<Field> fieldList = new ArrayList<>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;

    }

    protected Boolean isMap(Class<?> parameterType) {
        return Map.class.isAssignableFrom(parameterType);
    }
}
