package cn.com.duiba.kjy.base.api.enums.oa;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 公众号登录类型
 * @author lizhi
 * @date 2023/3/1 4:08 下午
 */
@Slf4j
@AllArgsConstructor
@Getter
public enum OaLoginTypeEnum {

    BASE("1", "静默授权", "snsapi_base"),
    USERINFO("2", "手动授权", "snsapi_userinfo"),
    ;

    /**
     * 登录类型
     */
    private final String type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 微信登录链接的scope
     */
    private final String scope;

    private static final Map<String, OaLoginTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OaLoginTypeEnum::getType, Function.identity(), (v1, v2) -> {
        log.error("OaLoginTypeEnum, type distinct, v1.name={}, v2.name={}", v1.name(), v2.name());
        return v2;
    })));

    public static OaLoginTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
