package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.enums.oa.OaLoginTypeEnum;
import cn.com.duiba.kjy.base.api.utils.UrlUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * 微信公众号登录工具类
 * @author lizhi
 * @date 2023/3/1 4:20 下午
 */
public class WechatOaLoginUtil {

    private WechatOaLoginUtil() {}

    /**
     * 公众号登录链接
     */
    private static final String LOGIN_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";

    /**
     * h5直播微信回调地址
     */
    private static final String LIVE_H5_CALLBACK_URI = "/auth/live/h5/callback";

    /**
     * h5直播微信公众号登录地址
     * @param server scheme+域名
     * @param appId 小程序appId
     * @param from 前端落地页
     * @param loginTypeEnum 登录类型枚举
     * @return 登录链接
     */
    public static String getLiveH5LoginUrl(String server, String appId, String from, OaLoginTypeEnum loginTypeEnum) {
        String encodeFrom = UrlUtils.encoder(from);
        String url = server + LIVE_H5_CALLBACK_URI;
        String redirectUri = UrlUtils.appendQueryParam(url, "from=" + encodeFrom, "type=" + loginTypeEnum.getType(), "appId=" + appId);
        return getLoginUrl(appId, redirectUri, loginTypeEnum, null);
    }

    /**
     * 获取微信公众号登录地址
     * @param appId 公众号appId
     * @param redirectUri 重定向地址
     * @param loginTypeEnum 登录类型枚举
     * @param state 登录过程中需要携带的参数
     * @return 登录链接
     */
    public static String getLoginUrl(String appId, String redirectUri, OaLoginTypeEnum loginTypeEnum, String state) {
        if (StringUtils.isAnyBlank(appId, redirectUri) || loginTypeEnum == null) {
            return null;
        }
        if (state == null) {
            state = "";
        }
        return String.format(LOGIN_URL, appId, redirectUri, loginTypeEnum.getScope(), state);
    }
}
