package cn.com.duiba.kjy.base.api.enums.inner;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 内部日志，事件类型枚举
 * @author lizhi
 * @date 2022/8/26 2:31 下午
 */
@Getter
@AllArgsConstructor
public enum InnerLocalLogEventTypeEnum {

    INVITATION("invitation", "邀请"),
    DELETE_INVITATION("delete_invitation", "删除邀请"),
    PRESENT("present", "到场"),
    ONLINE("online", "在线人数"),
    VISIT("visit", "观看时长"),
    CREATE_ORDER("create_order", "创建订单"),
    // 支付订单成功
    PAY_ORDER("pay_order", "支付订单"),
    // 自动收货/确认收货订单
    FINISH_ORDER("finish_order", "完成订单"),
    // 申请退款
    ORDER_REFUND("order_refund", "订单退款"),
    // 申请退款成功
    ORDER_REFUND_SUCCESS("order_refund_success", "订单退款成功"),
    // 审核拒绝订单
    ORDER_AUDIT_REJECT("order_audit_reject", "订单审核拒绝"),
    ORDER_AUDIT_REJECT_AUTO("order_audit_reject_auto", "订单自动审核拒绝"),
    // 微信收单失败、用户手动取消支付、超时支付、支付失败的订单
    ORDER_FAIL("order_fail", "订单失败"),
    // 直播活动订单
    LIVE_ACTIVITY_ORDER("live_activity_order", "直播活动订单"),
    ATTENDANCE_NUM("attendance_num", "出勤人数"),
    JOIN_TEAM("join_team", "代理人加入团队"),
    QUIT_TEAM("quit_team", "代理人退出团队"),
    APPOINTMENT("appointment", "预约直播"),
    READ_CLUE("read_clue", "代理人查看线索"),
    CLUE("clue", "产生线索"),
    LIVE_RESOURCE("live_resource", "产生线索-资料"),
    LIVE_AWARD("live_award", "产生线索-中奖"),
    LIVE_CHOICE_QUESTION("live_choice_question", "产生线索-投票"),
    LIVE_QUESTION("live_question", "产生线索-问题"),
    LIVE_REPLY("live_reply", "产生线索-评论"),
    SHARE("share", "分享直播间"),
    RED_PACKET("red_packet", "领取红包"),
    HELP("help", "直播助力"),
    BANK_CARD_ORDER("bank_card_order", "银行卡进件创建订单"),
    BANK_CARD_CALLBACK("bank_card_callback", "银行卡进件回传"),
    ;

    /**
     * 事件类型
     */
    private final String eventType;

    /**
     * 事件描述
     */
    private final String desc;
}
