package cn.com.duiba.kjy.base.api.enums.lottery;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 直播中奖类型
 *
 * @author zhanghuifeng
 * date 2021/2/3-14:34
 */
public enum LiveLotteryDrawTypeEnum {

    NORMAL_AWARD(1, "普通中奖"),

    SPECIFY_AWARD(2, "指定中奖"),

    COMPANY_SPECIFY_AWARD(3, "企业指定中奖"),

    QUESTION_AWARD(4, "答题中奖"),

    BAOXIANG_AWARD(5, "宝箱中奖"),
    ;

    public static final Set<LiveLotteryDrawTypeEnum> ALL_ENUM_SET = Arrays.stream(values()).collect(Collectors.toSet());

    private Integer code;
    private String desc;

    LiveLotteryDrawTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
