package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 微信浏览器都会带上标记 micromessenger / 版本，包括微信内置浏览器和企微内置浏览器
 * 企微浏览器会再额外带上：wxwork / 版本
 *
 * @author dugq
 * @date 2021/12/2 10:29 上午
 */
public final class WxRequestTool {

    private static final String WX_UA = "micromessenger";

    private static final String WX_WORK = "wxwork";

    /**
     * 判断当前请求是否微信环境，包括个微和企微
     */
    public static boolean isWxEvn(HttpServletRequest request){
        final String userAgent = RequestTool.getUserAgent(request);
        if (StringUtils.isBlank(userAgent)){
            return false;
        }
        return userAgent.toLowerCase().contains(WX_UA);
    }

    /**
     * 判断当前请求是否企微环境
     */
    public static boolean isWxWorkEvn(HttpServletRequest request){
        final String userAgent = RequestTool.getUserAgent(request);
        if (StringUtils.isBlank(userAgent)){
            return false;
        }
        final String ua = userAgent.toLowerCase();
        return ua.contains(WX_UA) && ua.contains(WX_WORK);
    }

    /**
     * 判断当前请求是否个微环境
     */
    public static boolean isPersonalWxEvn(HttpServletRequest request){
        final String userAgent = RequestTool.getUserAgent(request);
        if (StringUtils.isBlank(userAgent)){
            return false;
        }
        final String ua = userAgent.toLowerCase();
        return ua.contains(WX_UA) && !ua.contains(WX_WORK);
    }

}
