package cn.com.duiba.kjy.base.customweb.autoconfig;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.factory.HandlerMappingBeanFactory;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.converter.HttpMessageConverter;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/3/25 4:06 下午
 */
@Configuration
@AutoConfigureBefore(NettyAutoConfiguration.class)
@ConditionalOnBean(NettyServerConfigurationProperties.class)
@Slf4j
public class NettyWebAutoConfig {

    @Bean
    public RequestHandlerMappingAdaptor requestHandlerMappingAdaptor(){
        return new RequestHandlerMappingAdaptor();
    }


    @Bean
    public HandlerMappingBeanFactory handlerMappingBeanFactory(ObjectProvider<ParameterPostProcessor> parameterPostProcessors, ObjectProvider<ResponseHandler> responseHandlers){
        final List<ParameterPostProcessor> parameterPostProcessorList = parameterPostProcessors.stream().collect(Collectors.toList());
        final List<ResponseHandler> responseHandlerList = responseHandlers.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        return new HandlerMappingBeanFactory(parameterPostProcessorList, responseHandlerList);
    }

    @Bean
    public DispatcherHandler dispatcherHandler(ObjectProvider<RequestMappingsRegister> requestMappingsList, ObjectProvider<KjjInterceptor> interceptors){
        final List<RequestMappingsRegister> requestMappingRegisters = requestMappingsList.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        Collections.reverse(requestMappingRegisters);
        final List<KjjInterceptor> interceptorList = interceptors.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        Collections.reverse(interceptorList);
        return new DispatcherHandler(requestMappingRegisters,interceptorList);
    }

    /**
     * 重新注册http消息转换类。注意：此类是spring-web 框架使用的，实则适用tomcat的，但由于RPC也使用到，所以再加回来。
     * 有此类，上述的自定义converter才生效
     */
    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new CustomHttpMessageConverters(converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public ControllerMappingRegister controllerMapping(){
        return new ControllerMappingRegister();
    }

    /**
     * 附加logback配置文件
     * @return
     */
    @Bean
    public ApplicationListener accesslogLogbackConfig() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            private boolean flag = true;

            @Override
            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if(flag){
                    try {
                        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext(loggerContext);
                        //logback 添加新的配置文件
                        configurator.doConfigure(new ClassPathResource("/logback/access-logback.xml").getInputStream());
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                    flag = false;
                }
            }
        };
    }

}
