/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.filter;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.logger.filter.LoggerSizeFilter;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyWriterHttpServletResponseWrapper;
import cn.com.duibaboot.kjj.filter.AccessLogProps;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.AntPathMatcher;

public class KjjCustomAccessLogFilter
implements Filter,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(KjjCustomAccessLogFilter.class);
    private static final Logger accessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    public static final String OW_HOST = "host";
    private static final String OW_PATH = "accesslog_overwrite_path";
    private static final String ModeBlack = "black";
    private static final String ModeWhite = "white";
    private static final String COLLECT_COOKIE_MAP_KEY = "_accesslog_collect_cookie_map";
    private static final String LOG_COOKIE_ATTRIBUTE_KEY = "_accesslog_log_cookie";
    private static final String EX_ATTRIBUTE_KEY = "_accesslog_ex";
    private static final String OVERWRITE_ATTRIBUTE_KEY = "_accesslog_overwrite";
    private static final String DONT_WRITE_CURRENT_ACCESSLOG = "dont_write_current_accesslog";
    private String mode = "black";
    private Set<String> inhosts = new HashSet<String>();
    private Set<String> blackPaths = new HashSet<String>();
    private Set<String> blackUriPatterns = new HashSet<String>();
    private Map<String, String> cookieHosts = new ConcurrentHashMap<String, String>();
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    @Resource
    private LoggerSizeFilter loggerSizeFilter;
    @Value(value="${spring.application.name}")
    private String appName;
    @Resource
    private AccessLogProps accessLogProps;
    private static final String KJJ_ACCESS_UID = "kjj_access_uid";
    private static final String KJJ_ACCESS_SID = "kjj_access_sid";

    public void afterPropertiesSet() {
        try {
            Properties p = new Properties();
            ClassPathResource res = new ClassPathResource("/accesslog_filter.properties");
            if (!res.exists()) {
                return;
            }
            p.load(res.getInputStream());
            if (!p.isEmpty()) {
                this.loadConfig(p);
                log.info("load accesslog_filter.properties success");
            }
        }
        catch (Exception e) {
            log.warn("load accesslog_filter.properties failed", (Throwable)e);
        }
    }

    private void loadConfig(Properties properties) {
        List<String> hosts;
        this.mode = properties.getProperty("accesslog.mode");
        String hoststring = properties.getProperty("accesslog.hosts");
        if (hoststring != null && !CollectionUtils.isEmpty(hosts = Arrays.asList(hoststring.trim().split(",")))) {
            this.inhosts = new HashSet<String>(hosts);
        }
        String blackpaths = properties.getProperty("accesslog.blackpaths");
        List<String> paths = Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)blackpaths), (String)","));
        for (String path : paths) {
            if (path != null && !path.contains("*")) {
                this.blackPaths.add(path);
                continue;
            }
            if (path == null || !path.contains("*")) continue;
            this.blackUriPatterns.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = this.getServletRequest((HttpServletRequest)servletRequest);
        HttpServletResponse resp = this.getResp((HttpServletResponse)servletResponse);
        long start = System.currentTimeMillis();
        try {
            this.doBefore(req, resp);
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            this.doAfter(req, resp, System.currentTimeMillis() - start);
        }
    }

    public void printAsyncAccessLog(HttpServletRequest req, HttpServletResponse resp) {
        if (req.isAsyncStarted()) {
            this.doAfter(req, resp, -1L);
        } else {
            log.error("this methods can only be called at the Async servlet's thread");
        }
    }

    @NotNull
    private HttpServletResponse getResp(HttpServletResponse servletResponse) throws IOException {
        if (this.accessLogProps.isResponseBodyPrintFLag()) {
            return new BodyWriterHttpServletResponseWrapper(servletResponse);
        }
        return servletResponse;
    }

    private HttpServletRequest getServletRequest(HttpServletRequest req) {
        String method = StringUtils.lowerCase((String)this.getMethod(req));
        if (StringUtils.equals((CharSequence)method, (CharSequence)"post")) {
            return new BodyReaderHttpServletRequestWrapper(req);
        }
        return req;
    }

    protected void doBefore(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, String> collCookie = new HashMap<String, String>();
        try {
            this.addCookieIfNeed(req, resp, collCookie);
            this.addAttribute(req, COLLECT_COOKIE_MAP_KEY, collCookie);
        }
        catch (Exception e) {
            log.error("addCookieIfNeed error");
        }
    }

    protected void doAfter(HttpServletRequest req, HttpServletResponse resp, long cost) {
        try {
            boolean isPerfUrl = this.isPerfTestRequest(req);
            if (!isPerfUrl && this.needLog(req)) {
                Map collCookie = (Map)this.getAttribute(req, COLLECT_COOKIE_MAP_KEY);
                this.processAccessLog(req, resp, cost, collCookie);
            }
        }
        catch (Exception e) {
            log.error("AccessLogFilter process error, message=", (Throwable)e);
        }
    }

    private void addCookieIfNeed(HttpServletRequest req, HttpServletResponse resp, Map<String, String> collCookie) {
        List<String> parameterNames = this.getParameterNames(req);
        String host = this.getHeader(req, OW_HOST);
        String cookieHost = this.getCookieHost(host);
        for (String key : parameterNames) {
            String verify;
            String[] v;
            if (!key.startsWith("tck_") || (v = key.split("_")).length != 3 || !(verify = SecurityUtils.encode2StringByMd5((String)v[1])).endsWith(v[2])) continue;
            String name = v[1];
            String value = this.getParameter(req, key);
            String cookiekey = "_coll_" + name;
            collCookie.put(cookiekey, value);
            try {
                this.addCookie(resp, cookiekey, value, cookieHost, "/");
            }
            catch (Exception e) {
                log.error("addCookie error,cookieKey=" + cookiekey + ",value=" + value, (Throwable)e);
            }
        }
    }

    private void processAccessLog(HttpServletRequest req, HttpServletResponse resp, long cost, Map<String, String> collCookie) throws Exception {
        String responseBody;
        String method = StringUtils.lowerCase((String)this.getMethod(req));
        if (!"get".equals(method) && !"post".equals(method)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("app_name", this.appName);
        map.put("url_host", this.getHost(req));
        String path = this.clearRequestURI(this.getPath(req));
        map.put("url_path", path);
        map.put("url_query", this.getQueryString(req));
        if (method.equals("post") && req instanceof BodyReaderHttpServletRequestWrapper) {
            map.put("rb", ((BodyReaderHttpServletRequestWrapper)req).getBody());
        }
        this.putIfNotNull(map, "uid", this.getAttribute(req, KJJ_ACCESS_UID));
        this.putIfNotNull(map, "sid", this.getAttribute(req, KJJ_ACCESS_SID));
        map.put("http_method", method);
        int status = this.getStatus(resp);
        this.putLocation(status, req, resp);
        map.put("rc", status);
        map.put("rt", cost);
        map.put("mip", NetUtils.getLocalIp());
        this.putIfNotNull(map, "ex", this.getExPair(req));
        String callback = this.getParameter(req, "callback");
        if (!StringUtils.isBlank((CharSequence)callback)) {
            map.put("http_method", "POST");
        }
        Map<String, String> cookieMap = this.getCookieMap(req);
        this.handleCookies(cookieMap, collCookie);
        this.handleParams(req, collCookie);
        this.handleLogCookie(req, collCookie);
        this.putIfNotEmpty(map, "cookie", collCookie);
        this.putUa(req, map);
        if (resp instanceof BodyWriterHttpServletResponseWrapper && StringUtils.isNotBlank((CharSequence)(responseBody = new String(((BodyWriterHttpServletResponseWrapper)resp).getResponseBody())))) {
            map.put("pb", StringUtils.substring((String)responseBody, (int)0, (int)this.accessLogProps.getResponseBodyMaxLength()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = this.getHeader(req, "referer");
        this.putIfNotNull(map, "referer", referer);
        String ip = this.getIpAddr(req);
        this.putIfNotNull(map, "ip", ip);
        String body = JSON.toJSONString(map);
        if (body.length() >= this.loggerSizeFilter.getWarnThreshold()) {
            map.remove("pb");
            map.remove("rb");
            log.info("access Log too large so rm request body and response body ! url = {}", (Object)path);
            body = JSON.toJSONString(map);
        }
        accessLog.info(body);
        if (this.accessLogProps.isPrintAccessLogIntoApplication()) {
            log.info(body);
        }
    }

    private void putLocation(int status, HttpServletRequest req, HttpServletResponse resp) {
        try {
            if (status == 302) {
                this.putExPair(req, "ln", resp.getHeader("Location"));
            }
        }
        catch (Exception e) {
            log.info("put location error", (Throwable)e);
        }
    }

    private Map<String, Object> getExPair(HttpServletRequest req) {
        return (Map)this.getAttribute(req, EX_ATTRIBUTE_KEY);
    }

    public void setUid(HttpServletRequest req, Long uid) {
        if (Objects.isNull(uid)) {
            return;
        }
        req.setAttribute(KJJ_ACCESS_UID, (Object)uid);
    }

    public void setSid(HttpServletRequest req, Long sid) {
        if (Objects.isNull(sid)) {
            return;
        }
        req.setAttribute(KJJ_ACCESS_SID, (Object)sid);
    }

    private void putUa(HttpServletRequest req, Map<String, Object> map) {
        String ua = StringUtils.trimToEmpty((String)this.getHeader(req, "user-agent"));
        if (ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (!StringUtils.isEmpty((CharSequence)ua)) {
            map.put("user_agent", ua);
        }
    }

    private void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIfNotEmpty(Map<String, Object> map, String key, Map<String, String> collCookie) {
        if (!collCookie.isEmpty()) {
            map.put(key, collCookie);
        }
    }

    private void handleCookies(Map<String, String> cookieMap, Map<String, String> collCookie) {
        for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
            String key = entry.getKey();
            String cookie = entry.getValue();
            if (!key.startsWith("_coll_")) continue;
            collCookie.put(key, cookie);
        }
    }

    private void handleParams(HttpServletRequest req, Map<String, String> collCookie) {
        String deviceId;
        String slotId = this.getParameter(req, "adslotId");
        if (slotId != null) {
            collCookie.put("_coll_slot", slotId);
        }
        if ((deviceId = this.getParameter(req, "deviceId")) != null) {
            collCookie.put("_coll_device", deviceId);
        }
    }

    private void handleLogCookie(HttpServletRequest req, Map<String, String> collCookie) {
        Map<String, String> logCookie = this.getLogCookie(req);
        if (logCookie != null) {
            for (Map.Entry<String, String> entry : logCookie.entrySet()) {
                collCookie.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, String> getLogCookie(HttpServletRequest req) {
        return (Map)this.getAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY);
    }

    private String clearRequestURI(String requestURI) {
        if (StringUtils.isBlank((CharSequence)requestURI)) {
            return requestURI;
        }
        return StringUtils.replace((String)requestURI, (String)"//", (String)"/");
    }

    private String getCookieHost(String host) {
        String cookieHost;
        if (host == null) {
            return null;
        }
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(58));
        }
        if ((cookieHost = this.cookieHosts.get(host)) != null) {
            return cookieHost;
        }
        String hostLow = host.toLowerCase();
        if (hostLow.endsWith(".duiba.com.cn")) {
            cookieHost = "duiba.com.cn";
        } else if (hostLow.endsWith(".dui88.com")) {
            cookieHost = "dui88.com";
        } else if (hostLow.endsWith(".duibar.com")) {
            cookieHost = "duibar.com";
        } else if (hostLow.endsWith(".tuia.cn")) {
            cookieHost = "tuia.cn";
        }
        if (cookieHost != null) {
            this.cookieHosts.put(host, cookieHost);
        }
        return cookieHost;
    }

    public void putLogCookie(HttpServletRequest req, String key, String value) {
        this.ensureSafeCall();
        HashMap<String, String> map = (HashMap<String, String>)this.getAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, String>();
            this.addAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void putExPair(HttpServletRequest req, String key, Object value) {
        this.ensureSafeCall();
        HashMap<String, Object> map = (HashMap<String, Object>)this.getAttribute(req, EX_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.addAttribute(req, EX_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void putOverWritePair(HttpServletRequest req, String key, String value) {
        this.ensureSafeCall();
        HashMap<String, String> map = (HashMap<String, String>)this.getAttribute(req, OVERWRITE_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, String>();
            this.addAttribute(req, OVERWRITE_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void dontWriteCurrentLog(HttpServletRequest req) {
        this.addAttribute(req, DONT_WRITE_CURRENT_ACCESSLOG, true);
    }

    private String getPath(HttpServletRequest req) {
        String path = (String)this.getAttribute(req, OW_PATH);
        if (StringUtils.isBlank((CharSequence)path)) {
            path = this.getRequestURI(req);
        }
        return path;
    }

    private boolean needLog(HttpServletRequest req) {
        Boolean val = (Boolean)this.getAttribute(req, DONT_WRITE_CURRENT_ACCESSLOG);
        if (val != null && val.booleanValue()) {
            return false;
        }
        String host = this.getHost(req);
        if (ModeBlack.equals(this.mode) ? this.inhosts.contains(host) : ModeWhite.equals(this.mode) && !this.inhosts.contains(host)) {
            return false;
        }
        String path = this.clearRequestURI(this.getPath(req));
        if (this.blackPaths.contains(path)) {
            return false;
        }
        for (String pattern : this.blackUriPatterns) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            return false;
        }
        return true;
    }

    private String getHost(HttpServletRequest req) {
        String host;
        Map map = (Map)this.getAttribute(req, OVERWRITE_ATTRIBUTE_KEY);
        if (map != null && (host = (String)map.get(OW_HOST)) != null) {
            return host;
        }
        return this.getHeader(req, OW_HOST);
    }

    public void setOverWritePath(HttpServletRequest req, String path) {
        this.addAttribute(req, OW_PATH, path);
    }

    protected String getRequestURI(HttpServletRequest req) {
        return req.getRequestURI();
    }

    protected String getMethod(HttpServletRequest req) {
        return req.getMethod();
    }

    protected String getQueryString(HttpServletRequest req) {
        return req.getQueryString();
    }

    protected String getHeader(HttpServletRequest req, String key) {
        return req.getHeader(key);
    }

    protected String getIpAddr(HttpServletRequest req) {
        return HttpRequestUtils.getIpAddr((HttpServletRequest)req);
    }

    protected void addAttribute(HttpServletRequest req, String key, Object value) {
        req.setAttribute(key, value);
    }

    protected Object getAttribute(HttpServletRequest req, String key) {
        return req.getAttribute(key);
    }

    protected String getParameter(HttpServletRequest req, String key) {
        return req.getParameter(key);
    }

    protected List<String> getParameterNames(HttpServletRequest req) {
        return EnumerationUtils.toList((Enumeration)req.getParameterNames());
    }

    protected int getStatus(HttpServletResponse resp) {
        return resp.getStatus();
    }

    protected void addCookie(HttpServletResponse resp, String key, String value, String domain, String path) {
        Cookie cookie = new Cookie(key, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie(cookie);
    }

    protected boolean isPerfTestRequest(HttpServletRequest req) {
        return PerfTestUtils.isPerfTestRequest((HttpServletRequest)req);
    }

    protected Map<String, String> getCookieMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c.getValue());
            }
        }
        return cookieMap;
    }

    protected void ensureSafeCall() {
        String threadName = StringUtils.defaultString((String)Thread.currentThread().getName());
        if (!(threadName.startsWith("http-nio") || threadName.startsWith("XNIO") || threadName.startsWith("qtp") || threadName.equals("main"))) {
            log.error("KjjCustomAccessLogFilter's methods can only be called at the servlet's thread");
        }
    }

    public void destroy() {
    }
}

