package cn.com.duiba.kjy.api.constant;


import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    SELLER("seller", "销售员名片"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ContentTypeEnum type : values()){
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code){
        ContentTypeEnum result = ENUM_MAP.get(code);
        if(result == null){
           return null;
        }
        return result;
    }

}
