package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.TodayVisitDto;
import cn.com.duiba.kjy.api.dto.UserVisitedContentDto;
import cn.com.duiba.kjy.api.dto.UsersVisitDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchVisitListParam;
import cn.com.duiba.kjy.api.params.UserVisitContentParam;
import cn.com.duiba.kjy.api.params.UserVisitParam;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteUserVisitService {

    /**
     * 保存访问记录
     *
     * @param dto
     * @return
     */
    Long save(UsersVisitDto dto);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @param userId   用户ID
     * @param sellerId 销售员ID
     * @param type     访问类型
     * @return
     */
    UsersVisitDto findLastByParam(Long userId, Long sellerId, String type);

    /**
     * 查询文章访问记录列表
     *
     * @param searchVisitListParam
     * @return
     */
    Page<UsersVisitDto> getCustomerVisitList(SearchVisitListParam searchVisitListParam);

    /**
     * 查询用户浏览记录
     *
     * @param param
     * @return
     */
    Page<UserVisitedContentDto> selectUserVisitedContents(UserVisitContentParam param);

    /**
     * 查询单篇文章的访问记录
     *
     * @param param
     * @return
     */
    Page<UsersVisitDto> contentVisitInfo(SearchVisitListParam param);

    /**
     * 查询发布的单篇文章访问总时长
     *
     * @param sellerId 销售id
     * @param scId     销售文章id
     * @return
     */
    Long getTotalReadDuration(Long sellerId, Long scId);

    /**
     * 更新阅读时长
     *
     * @param visitId
     * @return
     */
    Boolean updateDuration(Long visitId);

    /**
     * 批量查询每篇文章访问总时长
     *
     * @param scIds
     * @return
     */
    Map<Long, Long> getReadDurationMap(List<Long> scIds);

    /**
     * 批量获取每篇文章访问总人数
     * @param scIds
     * @return
     */
    Map<Long, Integer> getReadNumMap(List<Long> scIds);

    /**
     * 批量修改客户绑定关系
     * @param sellerId
     * @param userId
     * @return
     */
    Integer sellerUserBind(Long sellerId,Long userId);

    TodayVisitDto countTodayBySeller(UserVisitParam param);

    Boolean markVisitAlready(Long sellerId);
}
