package cn.com.duiba.kjy.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.TagAddDto;
import cn.com.duiba.kjy.api.dto.tag.TagDetailDto;
import cn.com.duiba.kjy.api.dto.tag.TagDto;

import java.util.List;

/**
 * 标签相关服务
 * @author zhanghuifeng
 * date 2019-04-10-11:46
 */
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 添加
     * @param tagAddDto
     * @return
     */
    Boolean add(TagAddDto tagAddDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 编辑
     * @param tagDto
     * @return
     */
    Boolean update(TagDto tagDto);

    /**
     * 查询标签详细信息
     * @param id
     * @return
     */
    TagDetailDto findDetail(Long id);

    /**
     * 根据上级标签ID获取下级标签列表数据
     * @param parentTagId
     * @return
     */
    List<TagDto> findByParentTagId(Long parentTagId);

    /**
     * 根据分类ID获取标签数量
     * @param typeId
     * @return
     */
    long countByTypeId(Long typeId);

    /**
     * 获取下级标签数量
     * @param parentTagId
     * @return
     */
    long countByParentTagId(Long parentTagId);

    /**
     * 获取存在下级标签的上级标签ID集合
     * @param parentTagIds
     * @return
     */
    List<Long> findExitsLowTag(List<Long> parentTagIds);

    /**
     * 查询
     * @param id
     * @return
     */
    TagDto findById(Long id);
}
