package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.ContentExtDto;
import cn.com.duiba.kjy.api.dto.ContentMatrixDto;
import cn.com.duiba.kjy.api.dto.ContentSimpleInfo;
import cn.com.duiba.kjy.api.params.ContentSearchParams;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteContentService {

    /**
     * 查询文章列表
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectList(ContentSearchParams contentSearchParams);

    /**
     * 查询总数
     * @param params
     * @return
     */
    Long selectCount(ContentSearchParams params);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findByIds(List<Long> ids);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findAllByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentExtDto findExtByContentId(Long id);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentExtDto> findExtByIds(List<Long> ids);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentMatrixDto> findMatrixByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentDto findByContentId(Long id);

    /**
     * 新增内容 包含主体
     * @param contentExtDto
     * @return
     * @throws KjyCenterException
     */
    Long insert(ContentExtDto contentExtDto) throws KjyCenterException;

    /**
     * 跟新内容 包含主体
     * @param contentExtDto
     * @return
     */
    Integer update(ContentExtDto contentExtDto);

    /**
     * 更新内容
     * @param contentExtDto
     * @return
     */
    Boolean updateContent(ContentExtDto contentExtDto);

    /**
     * 跟新内容 包含主体
     *
     * @deprecated
     * @param status
     * @return
     */
    @Deprecated
    Boolean updateStatus(Long id, Integer status) throws KjyCenterException;

    /**
     * 批量删除 包含主体
     * @param ids
     * @return
     */
    Integer bathDelete(List<Long> ids);

    /**
     * 发布/撤回 内容
     * @param id
     * @param open
     * @return
     */
    Integer openContent(Long id, Integer open);

    /**
     * 跟新排序 上移，下移
     * @param id
     * @param sort ： >0 上移 < 0下移
     * @param contentType 内容类型
     * @return
     */
    Integer updateSort(Long id, Integer sort, ContentTypeEnum contentType);


    Integer updateContentTargetDestination(Long id, Integer destination, ContentTypeEnum contentType) throws KjyCenterException;


    /**
     * 跟新文章的敏感词检测结果
     * @param id
     * @param suggestion
     * @return
     */
    Integer updateArticleSuggestion(Long id,String suggestion);

    Integer update2TargetDestination(Long id, Integer destination, ContentSearchParams params) throws KjyCenterException;

    /**
     * 文章分享次数加1
     * @param contentId
     * @return
     */
    Boolean sharedNumIncrease(Long contentId,Long sellerId);

    Boolean downloadNumIncrease(Long contentId);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean updateMatrixPriorityGrade(Long id, Integer grade);

    /**
     * 根据指定日期查询是否存在日报
     * @param releaseTime
     * @return
     */
    ContentDto findDailyByDate(Date releaseTime);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean openDaily(Long id);

    /**
     * 获取发布中的日报
     * @return
     */
    ContentDto selectInitDaily();

    ContentDto nextCrawlerArticle(Long id);
    /**
     * 查询文章列表(管理后台专用)
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectListForBackend(ContentSearchParams contentSearchParams);

    /**
     * 查询总数(管理后台专用)
     * @param params
     * @return
     */
    Long selectCountForBackend(ContentSearchParams params);

    /**
     * 获取简单信息
     * @param id
     * @param contentType
     * @return
     */
    ContentSimpleInfo findSimpleInfo(Long id, String contentType);

}
