package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SimpleDto;
import cn.com.duiba.kjy.api.dto.company.CompanyDto;
import cn.com.duiba.kjy.api.params.company.CompanyPageQryParams;

import java.util.List;

/**
 * 公司服务
 * @author zhanghuifeng
 * date 2019-04-17-16:41
 */
@AdvancedFeignClient
public interface RemoteCompanyService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean add(CompanyDto dto);

    /**
     * 批次查询
     * @param ids
     * @return
     */
    List<CompanyDto> listByIds(List<Long> ids);

    /**
     * 获取所有
     * @return
     */
    List<SimpleDto> findAll();

    /**
     * 分页查询
     * @param params
     * @return
     */
    List<CompanyDto> findPageList(CompanyPageQryParams params);

    /**
     * 分页查询获取总数
     * @param params
     * @return
     */
    int findPageCount(CompanyPageQryParams params);

    /**
     * 编辑
     * @param dto
     * @return
     */
    Boolean update(CompanyDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);


    CompanyDto getById(Long id);
}
