package cn.com.duiba.kjy.api.dto.order;

import cn.com.duiba.kjy.api.enums.order.WithdrawStatusEnum;

import java.io.Serializable;

/**
* 提现订单
*/
public class WithdrawalOrderDto implements Serializable {

    private static final long serialVersionUID = -530985641092802587L;

    /**
    * 提现订单号
    */
    private Long orderNo;

    /**
    * 业务方id
    */
    private String bizId;

    /**
    * 用户的标识，对当前公众号唯一
    */
    private String openId;

    /**
    * 渠道返回的交易流水号
    */
    private String paymentNo;

    /**
    * 0创建提现 1提现中 2提现成功 3提现失败
     * @see WithdrawStatusEnum
    */
    private Integer withdrawStatus;

    /**
    * 提现金额大于0，单位为分
    */
    private Integer amount;

    /**
    * 提现时额外的渠道信息
    */
    private String extra;

    /**
    * 提现描述
    */
    private String description;

    /**
    * 提现失败后渠道方返回的错误码
    */
    private String failureCode;

    /**
    * 提现失败后渠道方返回的错误描述
    */
    private String failureMsg;

    public void setOrderNo(Long orderNo) {
        this.orderNo = orderNo;
    }

    public Long getOrderNo() {
        return orderNo;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setPaymentNo(String paymentNo) {
        this.paymentNo = paymentNo;
    }

    public String getPaymentNo() {
        return paymentNo;
    }

    public void setWithdrawStatus(Integer withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public Integer getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getExtra() {
        return extra;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }

    public String getFailureMsg() {
        return failureMsg;
    }

    public String getFailureCode() {
        return failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }
}

