package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.MarketAreaItemCompanyDto;
import cn.com.duiba.kjy.api.dto.MarketAreaItemDto;
import cn.com.duiba.kjy.api.params.MarketAreaItemParam;
import cn.com.duiba.kjy.api.params.MarketAreaSearchParam;

import java.util.List;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteMarketAreaService {

    Boolean insert(MarketAreaItemParam dto);

    Boolean update(MarketAreaItemParam dto);

    Boolean updateState(Long id, Integer state, Long companyId);

    Boolean delete(Long id);

    MarketAreaItemDto findById(Long id);

    List<MarketAreaItemDto> selectList(MarketAreaSearchParam param);

    Long selectCount(MarketAreaSearchParam param);

    List<MarketAreaItemCompanyDto> findByCompany(Long companyId);

}
