package cn.com.duiba.kjy.api.dto.seller;

import java.io.Serializable;
import java.util.Date;

/**
* 销售员账户流水信息
*/
public class SellerAccountDetailDto implements Serializable {

    private static final long serialVersionUID = -1352323695237856988L;

    /**
    * 流水号
    */
    private Long detailNo;

    /**
    * 销售员id
    */
    private Long sellerId;

    /**
    * 变更金额(分)
    */
    private Integer changeMoney;

    /**
    * 变更前余额(分)
    */
    private Integer beforeAmount;

    /**
    * 变更类型，1:支出；2:收入
     * @see cn.com.duiba.kjy.api.enums.seller.SellerAccountChangeTypeEnum
    */
    private Integer changeType;

    /**
    * 业务类型，1:余额提现；2:邀请奖励；3:二级奖励;
     * @see cn.com.duiba.kjy.api.enums.seller.SellerAccountBizTypeEnum
    */
    private Integer bizType;

    /**
    * 业务ID
    */
    private String bizId;

    /**
    * 状态，1:处理中；2:成功;3:失败
     * @see cn.com.duiba.kjy.api.enums.seller.SellerAccountDetailStateEnum
    */
    private Integer state;

    /**
     * 好友/下级ID
     */
    private Long subordinateId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    public void setDetailNo(Long detailNo) {
        this.detailNo = detailNo;
    }

    public Long getDetailNo() {
        return detailNo;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setChangeMoney(Integer changeMoney) {
        this.changeMoney = changeMoney;
    }

    public Integer getChangeMoney() {
        return changeMoney;
    }

    public void setBeforeAmount(Integer beforeAmount) {
        this.beforeAmount = beforeAmount;
    }

    public Integer getBeforeAmount() {
        return beforeAmount;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getState() {
        return state;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Long getSubordinateId() {
        return subordinateId;
    }

    public void setSubordinateId(Long subordinateId) {
        this.subordinateId = subordinateId;
    }
}

