package cn.com.duiba.kjy.api.enums.exclusive;

/**
 * @author zhanghuifeng
 * date 2019-04-29-19:31
 */
public enum ExclusiveAreaItemTypeEnum {

    ARTICLE("article", "文章"),
    POSTER("poster","海报"),
    ACTIVITY("activity", "活动"),
    CUSTOM("custom", "自定义链接"),
    ;
    private String code;

    private String desc;

    ExclusiveAreaItemTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static ExclusiveAreaItemTypeEnum getByCode(String code) {
        for (ExclusiveAreaItemTypeEnum enumVal : ExclusiveAreaItemTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        for (ExclusiveAreaItemTypeEnum enumVal : ExclusiveAreaItemTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
