package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售员账户明细业务类型枚举
 * @author zhanghuifeng
 * date 2019-05-17-11:11
 */
public enum SellerAccountBizTypeEnum {

    WITHDRAW(1, "余额提现"),
    INVITE_AWARD(2, "邀请奖励"),
    SECOND_INVITE_AWARD(3, "二级奖励"),
    WITHDRAW_BACK(4, "余额提现失败退回"),
    ;
    private Integer code;

    private String desc;

    SellerAccountBizTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerAccountBizTypeEnum getByCode(Integer code) {
        for (SellerAccountBizTypeEnum enumVal : SellerAccountBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerAccountBizTypeEnum enumVal : SellerAccountBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
