package cn.com.duiba.kjy.api.params;

import cn.com.duiba.kjy.api.enums.ContentSellerImportEnum;
import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * Created by dugq on 2019-02-13.
 */
@Data
@ToString
public class ContentSearchParams extends PageQuery  {

    private static final long serialVersionUID = -5169344283634890459L;

    /**
     * 标题搜索 左匹配
     */
    private String title;

    /**
     * 状态搜索
     */
    private Integer status;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 多状态
     */
    private List<Integer> statusList;

    private Long tag1Id;

    private Long tag2Id;

    private Integer recommend;

    private Integer publicly;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 是否是销售员上传的
     * @see ContentSellerImportEnum
     */
    private Integer sellerImport;

}
