package cn.com.duiba.kjy.api.enums.push;


import java.util.Objects;

/**
 * 推送
 * @author lizhi
 * @date 2019/6/24 1:51 PM
 */
public enum PushEnum {
    //推送类型
    DAILY(1, "今日早报更新提醒"),
    AFTERNOON(2, "午后话题更新提醒"),
    EVENING(3, "晚安心语更新提醒"),
    HOT_ARTICLE(4, "爆款热文推荐"),
    VISIT(5, "意向客户来访提醒"),
    DAILY_STATISTICS(6, "每日客户数据统计"),
    WEEKLY_STATISTICS(7, "每周客户数据统计"),
    DAILY_EARNINGS(8, "每日收益统计"),
    ;

    private Integer pushType;
    private String pushName;

    PushEnum(Integer pushType, String typeName) {
        this.pushType = pushType;
        this.pushName = typeName;
    }

    public static PushEnum getByPushType(Integer pushType) {
        if (Objects.isNull(pushType)) {
            return null;
        }
        for (PushEnum pushEnum : values()) {
            if (Objects.equals(pushEnum.getPushType(), pushType)) {
                return pushEnum;
            }
        }
        return null;
    }

    public Integer getLabel() {
        switch (this) {
            case DAILY:
                return PushLabelEnum.MATERIAL.getLabel();
            case AFTERNOON:
                return PushLabelEnum.MATERIAL.getLabel();
            case EVENING:
                return PushLabelEnum.MATERIAL.getLabel();
            case HOT_ARTICLE:
                return PushLabelEnum.MATERIAL.getLabel();
            case VISIT:
                return PushLabelEnum.VISIT_ME.getLabel();
            case DAILY_STATISTICS:
                return PushLabelEnum.VISIT_ME.getLabel();
            case WEEKLY_STATISTICS:
                return PushLabelEnum.VISIT_ME.getLabel();
            case DAILY_EARNINGS:
                return PushLabelEnum.VIP_EXCLUSIVE.getLabel();
            default:
                return null;
        }
    }

    public Integer getPushType() {
        return pushType;
    }

    public String getPushName() {
        return pushName;
    }
}
