package cn.com.duiba.kjy.api.remoteservice;

import java.util.Set;

/**
 * 推送开关配置服务类
 * @author lizhi
 * @date 2019/6/24 2:58 PM
 */
public interface RemoteSellerPushSwitchService {

    /**
     * 销售员该推送是否关闭
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @return true-关闭，false-未关闭
     */
    Boolean isClose(Long sellerId, Integer pushType);

    /**
     * 获取关闭该推送的所有销售员
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @return 销售员ID集合
     */
    Set<Long> getCloseSellerIdByPushType(Integer pushType);

    /**
     * 获取销售员关闭的所有推送
     * @param sellerId 销售员ID
     * @return 该销售员关闭的所有推送的类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     */
    Set<Integer> getClosePushTypesBySellerId(Long sellerId);

    /**
     * 开启/关闭销售员推送
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @param pushSwitch 开启/关闭
     * @see cn.com.duiba.kjy.api.enums.push.PushSwitchEnum
     * @return
     */
    Boolean closeOrOpenPush(Long sellerId, Integer pushType, Integer pushSwitch);
}
