package cn.com.duiba.kjy.api.dto.billing;

import cn.com.duiba.kjy.api.enums.billing.BillingPlanTaskStatusEnum;
import cn.com.duiba.kjy.api.enums.billing.BillingPlanTaskTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhanghuifeng
 * date 2020/9/18-15:43
 */
@Data
public class BillingPlanTaskDto implements Serializable {
    private static final long serialVersionUID = 7755842811933286762L;

    private Long id;

    /**
     * 代理人ID
     */
    private Long sellerId;

    /**
     * 状态 1:进行中 2:完成 3:失败
     * @see BillingPlanTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 第几天
     */
    private Integer currentDay;

    /**
     * 任务类型,1完善名片,2使用贺卡,3使用抽奖工具,4给客户备注分类,5查看周报,6转发早报,7转发两篇种,8查看跟进线索
     * @see BillingPlanTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 任务完成时间
     */
    private Date completedDate;

    /**
     * 任务需要完成时间
     */
    private Integer needFinishDay;

    /**
     * 任务需要完成次数
     */
    private Integer needFinishTimes;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
