package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * 60天开单计划任务状态
 * @author zhanghuifeng
 * date 2020/9/18-11:13
 */
public enum BillingPlanTaskStatusEnum {

    INIT(1, "进行中"),
    COMPLETE(2, "完成"),
    FAIL(3, "失败"),
    REFUND(4, "发起退款"),

    ;

    private Integer code;
    private String desc;

    BillingPlanTaskStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingPlanTaskStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingPlanTaskStatusEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingPlanTaskStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
