package cn.com.duiba.kjy.api.enums.seller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-06-12 11:32
 * @descript 阅读偏好标签enum
 */
public enum ReadPreferenceTagEnum {

    TAG1("时事热点", 0, 5),
    TAG2("正能量", 5, 10),
    TAG3("健康科普", 10, 15),
    TAG4("投资理财", 15, 20),
    TAG5("趣味互动", 20, 25),
    TAG6("育儿专栏", 25, 30),
    TAG7("社保商保", 30, 35),
    TAG8("养老保险", 35, 40),
    TAG9("理财险", 40, 45),
    TAG10("健康险", 45, 50),
    TAG11("家庭保障", 50, 55),
    TAG12("意外险", 55, 60),
    TAG13("医疗险", 60, 65),
    TAG14("重疾险", 65, 70),
    TAG15("少儿险", 70, 75),
    TAG16("车险", 75, 80),
    TAG17("寿险", 80, 85),
    TAG18("增员意向", 85, 90),
    TAG19("职业发展", 90, 95),
    TAG20("保险意识", 95, 100),
    ;


    /**
     * 标签名称
     */
    private String name;
    /**
     * 开始位数
     */
    private Integer startIndex;
    /**
     * 结束位数
     */
    private Integer endIndex;

    ReadPreferenceTagEnum(String name, Integer startIndex, Integer endIndex) {
        this.name = name;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /**
     * 获取初始值
     * @return
     */
    public static String initData() {
        StringBuilder initData = new StringBuilder();
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            for (int i = 0; i < readPreferenceTagEnum.getEndIndex() - readPreferenceTagEnum.getStartIndex(); i++) {
                initData.append("0");
            }
        }
        return initData.toString();
    }


    /**
     * 根据内容的标签获取所属偏好
     * @param configTag 对应的标签配置
     * @param tagIds 内容的标签
     * @return
     */
    public static ReadPreferenceTagEnum getByTagIds(String configTag, List<Long> tagIds) {
        JSONObject jsonObject = JSONObject.parseObject(configTag);
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            JSONArray arrayVal = jsonObject.getJSONArray(readPreferenceTagEnum.name());
            if (CollectionUtils.isEmpty(arrayVal)) {
                continue;
            }
            List<Long> longArray = arrayVal.toJavaList(Long.class);
            for (Long tagId : tagIds) {
                if (longArray.contains(tagId)) {
                    return readPreferenceTagEnum;
                }
            }
        }
        return null;
    }

    /**
     * 计算最多的阅读偏好
     * @param readPreference
     * @return
     */
    public static String calculateMostReadPreference(String readPreference) {
        int length = readPreference.length();
        long val = 0L;
        String valName = "";
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            if (readPreferenceTagEnum.getEndIndex() > length) {
                continue;
            }
            String hexStr = readPreference.substring(readPreferenceTagEnum.getStartIndex(), readPreferenceTagEnum.getEndIndex());
            Long readPreferenceNum = Long.parseLong(hexStr, 16);
            if (readPreferenceNum > val) {
                val = readPreferenceNum;
                valName = readPreferenceTagEnum.getName();
            }
        }
        return valName;
    }

    public String getName() {
        return name;
    }

    public Integer getStartIndex() {
        return startIndex;
    }

    public Integer getEndIndex() {
        return endIndex;
    }
}
