/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.billing;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.enums.billing.BillingPlanTaskTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum ForwardContentTypeToTaskTypeEnum {
    USE_GREETING_CARD(ContentTypeEnum.GREETING_CARD.getCode(), BillingPlanTaskTypeEnum.USE_GREETING_CARD.getCode(), "\u4f7f\u7528\u8d3a\u5361"),
    USE_LOTTERY_TOOL(ContentTypeEnum.GAME_LOTTERY.getCode(), BillingPlanTaskTypeEnum.USE_LOTTERY_TOOL.getCode(), "\u4f7f\u7528\u62bd\u5956\u5de5\u5177"),
    USE_GAME_TEMPLATE(ContentTypeEnum.GAME_TEMPLATE.getCode(), BillingPlanTaskTypeEnum.USE_LOTTERY_TOOL.getCode(), "\u4f7f\u7528\u62bd\u5956\u5de5\u5177"),
    FORWARD_DAILY(ContentTypeEnum.DAILY.getCode(), BillingPlanTaskTypeEnum.FORWARD_DAILY.getCode(), "\u8f6c\u53d1\u65e9\u62a5");

    private String contentType;
    private Integer taskType;
    private String desc;
    private static final Map<String, ForwardContentTypeToTaskTypeEnum> ENUM_MAP;

    private ForwardContentTypeToTaskTypeEnum(String contentType, Integer taskType, String desc) {
        this.contentType = contentType;
        this.taskType = taskType;
        this.desc = desc;
    }

    public static ForwardContentTypeToTaskTypeEnum getByContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return ENUM_MAP.get(contentType);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<String, ForwardContentTypeToTaskTypeEnum>();
        for (ForwardContentTypeToTaskTypeEnum stateEnum : ForwardContentTypeToTaskTypeEnum.values()) {
            ENUM_MAP.put(stateEnum.getContentType(), stateEnum);
        }
    }
}

