package cn.com.duiba.kjy.api.enums.sellercustomerintention;

import cn.com.duiba.wolf.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-09-21 11:36
 * @descript 客户意向度模块枚举
 */
public enum SellerCustomerIntentionModuleEnum {
    VISIT_MODULE(1, "访问模块"),
    READ_MODULE(2, "阅读偏好模块"),
    INTERACT_MODULE(3, "互动模块"),
    ;


    private Integer code;

     private String description;

    SellerCustomerIntentionModuleEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据代码获取枚举
     * @param code
     * @return
     */
    public static SellerCustomerIntentionModuleEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (SellerCustomerIntentionModuleEnum sellerCustomerIntentionModuleEnum : SellerCustomerIntentionModuleEnum.values()) {
            if (Objects.equals(sellerCustomerIntentionModuleEnum.getCode(), code)) {
                return sellerCustomerIntentionModuleEnum;
            }
        }
        return null;
     }

    /**
     * 获取今日的数据
     * @return 20092122D
     */
    public static String getTodayData(String moduleVal, SellerCustomerIntentionModuleEnum sellerCustomerIntentionModuleEnum) {
        String today = String.valueOf(DateUtils.getYYDayNumber(new Date()));
        if (StringUtils.isNotBlank(moduleVal)) {
            for (int startIndex = 0, endIndex = 6; endIndex < moduleVal.length();) {
                String dateStr = moduleVal.substring(startIndex, endIndex);
                if (!StringUtils.equals(dateStr, today)) {
                    int dataLength = Integer.parseInt(moduleVal.substring(endIndex, endIndex + 2), 16);
                    startIndex = endIndex + 2 + dataLength;
                    endIndex = startIndex + 6;
                    continue;
                }
                return moduleVal.substring(startIndex);
            }
        }
        switch (sellerCustomerIntentionModuleEnum) {
            case INTERACT_MODULE:
                int i = 0;
                int enumNum = SellerCustomerIntentionClueEnum.values().length;
                String res = today + "0" + Integer.toHexString(enumNum);
                while (i < enumNum) {
                    res += "0";
                    i++;
                }
                return res;
            default:
                return today + "0200";
        }
     }
}
