package cn.com.duiba.kjy.api.enums.billing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务类型
 * @author zhanghuifeng
 * date 2020/9/18-11:19
 */
public enum BillingPlanTaskTypeEnum {

    PERFECT_CARD(1, "完善名片"),
    USE_GREETING_CARD(2, "使用贺卡"),
    USE_LOTTERY_TOOL(3, "使用抽奖工具"),
    CUSTOMER_REMARK(4, "给客户备注分类"),
    CHECK_WEEKLY_REPORTS(5, "查看周报"),
    FORWARD_DAILY(6, "转发早报"),
    FORWARD_SEEDING(7, "转发种草素材"),
    CHECK_FOLLOW_CLUE(8, "查看跟进线索"),

    ;

    private Integer code;
    private String desc;

    BillingPlanTaskTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingPlanTaskTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingPlanTaskTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingPlanTaskTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 周任务
     */
    public static List<Integer> weeklyList(){
        return Arrays.asList(USE_GREETING_CARD.getCode(),USE_LOTTERY_TOOL.getCode());
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
