package cn.com.duiba.kjy.api.enums.billing;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/9/22-20:03
 */
public enum ForwardContentTypeToTaskTypeEnum {

    USE_GREETING_CARD(ContentTypeEnum.GREETING_CARD.getCode(),BillingPlanTaskTypeEnum.USE_GREETING_CARD.getCode(), "使用贺卡"),
    USE_LOTTERY_TOOL(ContentTypeEnum.GAME_LOTTERY.getCode(),BillingPlanTaskTypeEnum.USE_LOTTERY_TOOL.getCode(), "使用抽奖工具"),
    FORWARD_DAILY(ContentTypeEnum.DAILY.getCode(),BillingPlanTaskTypeEnum.FORWARD_DAILY.getCode(), "转发早报"),
    ;

    private String contentType;
    private Integer taskType;
    private String desc;

    ForwardContentTypeToTaskTypeEnum(String contentType,Integer taskType, String desc) {
        this.contentType = contentType;
        this.taskType = taskType;
        this.desc = desc;
    }

    private static final Map<String, ForwardContentTypeToTaskTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ForwardContentTypeToTaskTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getContentType(), stateEnum);
        }
    }

    public static ForwardContentTypeToTaskTypeEnum getByContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return ENUM_MAP.get(contentType);
    }
    public String getContentType() {
        return contentType;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public String getDesc() {
        return desc;
    }
}
