package cn.com.duiba.kjy.api.enums.sellercard;

import java.util.Objects;

/**
 * Created by dugq on 2019-07-30.
 *
 * 1:待审核 2:审核通过 3:审核失败
 * 4:拒绝结果已读(针对客户前端展示未提交,针对管理平台 前端展示审核拒绝)
 */
public enum AuthStatusEnum {
    UN_COMMIT((byte)0,"未提交"),
    WAIT((byte)1,"待审核"),
    PASS((byte)2,"审核通过"),
    REFUSE((byte)3,"审核拒绝"),
    REFUSE_READED((byte)4,"拒绝结果已读"),


    ;
    private Byte code;
    private String desc;

    AuthStatusEnum(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AuthStatusEnum getByCode(Byte code) {
        for (AuthStatusEnum enumVal : AuthStatusEnum.values()) {
            if (Objects.equals(enumVal.getCode(), code)) {
                return enumVal;
            }
        }
        return null;
    }

}
